/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.batch.container.checkpoint;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.CheckpointAlgorithm;

public final class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private static final String className = ItemCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(ItemCheckpointAlgorithm.class.getPackage().getName());
    CheckpointAlgorithm ichkp = null;
    boolean inCheckpoint = false;
    private static final int defaultRecordValue = 10;
    private static final int defaultTimeValue = 10;
    private static final int defaultTimeoutValue = 60;
    int threshold = 10;
    long timeStarted = 0L;
    long requests = 0L;
    int timeout = 60;
    Date date = new Date();
    long ts = this.date.getTime();
    int interval = 10;
    long numTimes = 0L;
    int time;
    int item;

    public ItemCheckpointAlgorithm() {
        logger.finer("ITEMTIME: in ctor, ts = " + this.ts);
    }

    public void endCheckpoint() throws Exception {
        this.inCheckpoint = false;
    }

    public int getCheckpointTimeOut(int timeOut) throws Exception {
        return this.timeout;
    }

    public boolean isReadyToCheckpointItem() throws Exception {
        boolean itemready;
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        ++this.requests;
        boolean bl = itemready = this.requests >= (long)this.item;
        if (itemready) {
            logger.finer("ITEMTIMECHKPT: item checkpoint hit");
            long millis = new Date().getTime() - this.timeStarted;
            if (millis > 0L) {
                String rate = Integer.valueOf(Long.valueOf(this.requests * 1000L / millis).intValue()).toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" - true [requests/second " + rate + "]");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(" - true [requests " + this.requests + "]");
            }
        }
        if (itemready) {
            this.requests = 0L;
        }
        return itemready;
    }

    public boolean isReadyToCheckpointTime() throws Exception {
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        boolean timeready = false;
        ++this.numTimes;
        Date curDate = new Date();
        long curts = curDate.getTime();
        long curdiff = curts - this.ts;
        int diff = (int)curdiff / 1000;
        if (diff >= this.time) {
            logger.finer("ITEMTIMECHKPT: time checkpoint hit");
            timeready = true;
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("Num of requests=" + this.numTimes + " at a rate=" + this.numTimes / (long)diff + " req/sec");
            }
            this.numTimes = 0L;
            this.date = new Date();
            this.ts = this.date.getTime();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method, timeready);
        }
        return timeready;
    }

    public void setThreshold(int INthreshHold) {
        this.threshold = INthreshHold;
    }

    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready = false;
        if (this.time == 0) {
            if (this.isReadyToCheckpointItem()) {
                ready = true;
            }
        } else if (this.isReadyToCheckpointItem() || this.isReadyToCheckpointTime()) {
            ready = true;
        }
        return ready;
    }

    public void setThresholds(int itemthreshold, int timethreshold) {
        this.item = itemthreshold;
        this.time = timethreshold;
    }

    public void beginCheckpoint() throws Exception {
    }

    public int checkpointTimeout(int timeout) throws Exception {
        return 0;
    }
}

