/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IJobXMLLoaderService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.services.impl.DelegatingBatchArtifactFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

public class JobXMLLoaderServiceImpl
implements IJobXMLLoaderService {
    private static final Logger logger = Logger.getLogger(DelegatingBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = DelegatingBatchArtifactFactoryImpl.class.getName();
    protected static IJobXMLLoaderService preferredJobXmlLoader = (IJobXMLLoaderService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.JOBXML_LOADER_SERVICE);
    public static final String PREFIX = "/META-INF/batch-jobs/";

    @Override
    public String loadJob(String id) {
        String jobXML = preferredJobXmlLoader.loadJob(id);
        if (jobXML != null) {
            return jobXML;
        }
        jobXML = JobXMLLoaderServiceImpl.loadJobFromBatchJobs(id);
        if (jobXML == null) {
            throw new BatchContainerServiceException("Could not load job xml with id: " + id);
        }
        return jobXML;
    }

    private static String loadJobFromBatchJobs(String id) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL path = tccl.getResource(PREFIX + id + ".xml");
        String xmlString = JobXMLLoaderServiceImpl.readJobXML(path.getPath());
        return xmlString;
    }

    @Override
    public String loadStep(String id) {
        return null;
    }

    @Override
    public String loadXJCL(String id) {
        return null;
    }

    private static String readJobXML(String fileWithPath) {
        StringBuffer xmlBuffer = fileWithPath == null ? null : new StringBuffer();
        try {
            if (fileWithPath != null) {
                BufferedReader in = new BufferedReader(new FileReader(new File(fileWithPath)));
                String input = in.readLine();
                do {
                    if (input == null) continue;
                    xmlBuffer.append(input);
                    input = in.readLine();
                } while (input != null);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xmlBuffer == null ? null : xmlBuffer.toString();
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

