/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.services.IBatchKernelService;
import com.ibm.batch.container.services.IJobXMLLoaderService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.tck.bridge.IJobEndCallbackService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.exception.JobExecutionAlreadyCompleteException;
import javax.batch.operations.exception.JobExecutionIsRunningException;
import javax.batch.operations.exception.JobExecutionNotMostRecentException;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.JobInstanceAlreadyCompleteException;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.operations.exception.NoSuchJobException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.operations.exception.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class JobOperatorImpl
implements JobOperator {
    private static final String sourceClass = JobOperatorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ServicesManager servicesManager = ServicesManager.getInstance();
    private IBatchKernelService batchKernel = (IBatchKernelService)this.servicesManager.getService(ServicesManager.ServiceType.BATCH_KERNEL_SERVICE);
    private IJobEndCallbackService callbackService = (IJobEndCallbackService)this.servicesManager.getService(ServicesManager.ServiceType.CALLBACK_SERVICE);
    private IPersistenceManagerService persistenceService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
    private IJobXMLLoaderService jobXMLLoaderService = (IJobXMLLoaderService)this.servicesManager.getService(ServicesManager.ServiceType.JOBXML_LOADER_SERVICE);

    public long start(String jobXMLName, Properties submittedProps) throws JobStartException {
        String jobXML = this.jobXMLLoaderService.loadJob(jobXMLName);
        long executionId = 0L;
        if (logger.isLoggable(Level.FINE)) {
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        JobExecution execution = this.batchKernel.startJob(jobXML, submittedProps);
        executionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator start received executionId: " + executionId);
        }
        return executionId;
    }

    public void abandon(JobExecution jobExecution) throws NoSuchJobExecutionException, JobExecutionIsRunningException {
        boolean abandoned = false;
        long executionId = jobExecution.getExecutionId();
        JobExecution jobEx = this.persistenceService.jobOperatorGetJobExecution(executionId);
        if (jobEx == null) {
            throw new NoSuchJobInstanceException(null, "Job Execution: " + executionId + " not found");
        }
        if (jobEx.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTED) && jobEx.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTING)) {
            throw new JobExecutionIsRunningException(null, "Job Execution: " + executionId + " is still running");
        }
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.persistenceService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(jobEx.getExecutionId(), "batchstatus", JobOperator.BatchStatus.ABANDONED.name(), timestamp);
    }

    public List<JobExecution> getExecutions(JobInstance instance) throws NoSuchJobInstanceException {
        List<JobExecution> executions = this.persistenceService.jobOperatorGetJobExecutionsByJobInstanceID(instance.getInstanceId());
        if (executions.size() == 0) {
            throw new NoSuchJobInstanceException(null, "Job: " + instance.getJobName() + " has no executions");
        }
        return this.persistenceService.jobOperatorGetJobExecutionsByJobInstanceID(instance.getInstanceId());
    }

    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException {
        JobExecution execution = this.persistenceService.jobOperatorGetJobExecution(executionId);
        if (execution == null) {
            throw new NoSuchJobExecutionException(null, "No job execution exists for job execution id: " + executionId);
        }
        return this.batchKernel.getJobExecution(executionId);
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException {
        List<JobExecution> executions = this.persistenceService.jobOperatorGetJobExecutions(instance.getInstanceId());
        if (executions.size() == 0) {
            throw new NoSuchJobInstanceException(null, "Job: " + instance.getJobName() + " does not exist");
        }
        return this.persistenceService.jobOperatorGetJobExecutions(instance.getInstanceId());
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException {
        return this.batchKernel.getJobInstance(executionId);
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        int jobInstanceCount = 0;
        jobInstanceCount = this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
        if (jobInstanceCount > 0) {
            return jobInstanceCount;
        }
        throw new NoSuchJobException(null, "Job " + jobName + " not found");
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        List<Long> instanceIds = this.persistenceService.jobOperatorgetJobInstanceIds(jobName, start, count);
        if (instanceIds.size() > 0) {
            for (long id : instanceIds) {
                jobInstances.add(this.batchKernel.getJobInstance(id));
            }
            return jobInstances;
        }
        throw new NoSuchJobException(null, "Job Name " + jobName + " not found");
    }

    public Set<String> getJobNames() {
        return this.persistenceService.jobOperatorgetJobNames();
    }

    public Properties getParameters(JobInstance instance) throws NoSuchJobExecutionException {
        Properties props = this.persistenceService.getParameters(instance.getInstanceId());
        if (props == null) {
            throw new NoSuchJobExecutionException(null, "");
        }
        return this.persistenceService.getParameters(instance.getInstanceId());
    }

    public List<JobInstance> getRunningInstances(String jobName) throws NoSuchJobException {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        Set<Long> instanceIds = this.persistenceService.jobOperatorGetRunningInstances(jobName);
        if (instanceIds.size() > 0) {
            for (long id : instanceIds) {
                jobInstances.add(this.batchKernel.getJobInstance(id));
            }
            return jobInstances;
        }
        throw new NoSuchJobException(null, "Job Name " + jobName + " not found");
    }

    public List<StepExecution> getStepExecutions(long executionId) throws NoSuchJobExecutionException {
        return this.persistenceService.getStepExecutionIDListQueryByJobID(executionId);
    }

    public long restart(long executionId) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarting job with instanceID: " + executionId);
        }
        JobExecution execution = this.batchKernel.restartJob(executionId);
        long newExecutionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarted job with instanceID: " + executionId + ", and new executionID: " + newExecutionId);
        }
        return newExecutionId;
    }

    public long restart(long instanceId, Properties jobParameters) throws JobInstanceAlreadyCompleteException, NoSuchJobExecutionException, NoSuchJobException, JobRestartException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarting job with instanceID: " + instanceId);
        }
        JobExecution execution = this.batchKernel.restartJob(instanceId, jobParameters);
        long newExecutionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarted job with instanceID: " + instanceId + ", and new executionID: " + newExecutionId);
        }
        return newExecutionId;
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        this.batchKernel.stopJob(executionId);
    }
}

