/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IController;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.InjectionReferences;
import com.ibm.batch.container.artifact.proxy.JobListenerProxy;
import com.ibm.batch.container.artifact.proxy.ListenerFactory;
import com.ibm.batch.container.context.impl.JobContextImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.DecisionControllerImpl;
import com.ibm.batch.container.impl.ExecutionElementControllerFactory;
import com.ibm.batch.container.impl.SplitControllerImpl;
import com.ibm.batch.container.jobinstance.JobExecutionHelper;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IJobStatusManagerService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.batch.container.util.PartitionDataWrapper;
import com.ibm.batch.container.xjcl.ControlElement;
import com.ibm.batch.container.xjcl.ExecutionElement;
import com.ibm.batch.container.xjcl.Navigator;
import com.ibm.batch.container.xjcl.Transition;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.JobListener;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.StepExecution;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;
import jsr352.batch.jsl.Stop;

public class JobControllerImpl
implements IController {
    private static final String CLASSNAME = JobControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IJobStatusManagerService jobStatusService = null;
    private IPersistenceManagerService persistenceService = null;
    private RuntimeJobExecutionImpl jobExecution = null;
    private final JobContextImpl<?> jobContext;
    private final Navigator<JSLJob> jobNavigator;
    private final String jobId;
    private LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue;
    private ListenerFactory listenerFactory = null;
    private final long jobInstanceId;
    private volatile IExecutionElementController currentStoppableElementController = null;

    public JobControllerImpl(RuntimeJobExecutionImpl jobExecution) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.jobNavigator = jobExecution.getJobNavigator();
        this.jobId = this.jobNavigator.getId();
        this.jobInstanceId = jobExecution.getJobInstance().getInstanceId();
        this.jobStatusService = (IJobStatusManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.JOB_STATUS_MANAGEMENT_SERVICE);
        this.persistenceService = (IPersistenceManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
        this.setContextProperties();
        this.setupListeners();
    }

    private void setContextProperties() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSL();
        JSLProperties jslProps = jobModel.getProperties();
        if (jslProps != null) {
            Properties contextProps = this.jobContext.getProperties();
            for (Property property : jslProps.getPropertyList()) {
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
    }

    private void setupListeners() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSL();
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        this.listenerFactory = new ListenerFactory(jobModel, injectionRef);
        this.jobExecution.setListenerFactory(this.listenerFactory);
    }

    public void executeJob() {
        String methodName = "executeJob";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "executeJob");
        }
        try {
            if (JobOperator.BatchStatus.STOPPING.equals((Object)this.jobContext.getBatchStatus())) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(JobOperator.BatchStatus.STARTING);
            if (this.jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(JobOperator.BatchStatus.STARTED);
            List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @BeforeJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
                }
                listenerProxy.beforeJob();
            }
            if (this.jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.doExecutionLoop(this.jobNavigator);
            JobOperator.BatchStatus currentStatus = this.jobContext.getBatchStatus();
            if (currentStatus == null) {
                throw new IllegalStateException("Job BatchStatus should have been set by now");
            }
            JobOperator.BatchStatus curStatus = currentStatus;
            if (!curStatus.equals((Object)JobOperator.BatchStatus.FAILED) && !curStatus.equals((Object)JobOperator.BatchStatus.STOPPED)) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.COMPLETED);
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
            }
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @AfterJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
                }
                listenerProxy.afterJob();
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            this.updateJobBatchStatus(JobOperator.BatchStatus.FAILED);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Job failed with exception/error: " + t.getMessage());
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            block41: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Job complete for job id=" + this.jobExecution.getJobInstance().getJobName() + ", executionId=" + this.jobExecution.getExecutionId() + ", batchStatus=" + this.jobContext.getBatchStatus() + ", exitStatus=" + this.jobContext.getExitStatus());
                }
                try {
                    this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), this.jobContext.getBatchStatus(), this.jobContext.getExitStatus());
                    long time = System.currentTimeMillis();
                    Timestamp updateTS = new Timestamp(time);
                    this.jobExecution.setLastUpdateTime(updateTS);
                    if (this.persistenceService instanceof JDBCPersistenceManagerImpl) {
                        this.persistenceService.jobExecutionStatusStringUpdate(this.jobExecution.getExecutionId(), "exitstatus", this.jobContext.getExitStatus(), updateTS);
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block41;
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    logger.warning("Caught Throwable on updating execution status: " + sw.toString());
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASSNAME, "executeJob");
            }
        }
    }

    private void doExecutionLoop(Navigator jobNavigator) throws Exception {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        JobContextImpl<?> jobContext = this.jobExecution.getJobContext();
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = jobNavigator.getFirstExecutionElement(this.jobExecution.getRestartOn());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Job doesn't contain a step.", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        ExecutionElement previousExecutionElement = null;
        IExecutionElementController previousElementController = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new UnsupportedOperationException("Only support step, flow, and decision at the moment.");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecution, currentExecutionElement);
            elementController.setAnalyzerQueue(this.analyzerQueue);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement == null) {
                    elementController.setStepContext(null);
                } else {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision...OR CAN IT???");
                    }
                    if (previousExecutionElement instanceof Step) {
                        elementController.setStepContext(stepContext);
                        StepExecution lastStepExecution = this.getLastStepExecution((Step)previousExecutionElement);
                        ((DecisionControllerImpl)elementController).setStepExecution((Step)previousExecutionElement, lastStepExecution);
                    } else if (previousExecutionElement instanceof Split) {
                        List<StepExecution> stepExecutions = this.getSplitStepExecutions(previousElementController);
                        ((DecisionControllerImpl)elementController).setStepExecutions((Split)previousExecutionElement, stepExecutions);
                    } else if (previousExecutionElement instanceof Flow) {
                        Step last = this.getLastStepInTheFlow(previousExecutionElement);
                        StepExecution lastStepExecution = this.getLastStepExecution(last);
                        ((DecisionControllerImpl)elementController).setStepExecution((Flow)previousExecutionElement, lastStepExecution);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow) {
                String flowId = ((Flow)currentExecutionElement).getId();
            } else if (currentExecutionElement instanceof Split) {
                String splitId = ((Split)currentExecutionElement).getId();
            }
            if (jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            String executionElementExitStatus = null;
            try {
                executionElementExitStatus = elementController.execute();
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                throw new IllegalStateException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            this.currentStoppableElementController = null;
            previousElementController = elementController;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementExitStatus);
            }
            if (jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            nextTransition = jobNavigator.getNextTransition(currentExecutionElement, executionElementExitStatus);
            if (nextTransition == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop TODO: is this an expected state or not? ");
                }
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getControlElement() != null) {
            ControlElement controlElem = nextTransition.getControlElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + controlElem);
            }
            if (controlElem instanceof Stop) {
                String restartOn = ((Stop)controlElem).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + controlElem + " with restartOn=" + restartOn);
                }
                this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPED);
                this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
                String newExitStatus = ((Stop)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return;
            }
            if (controlElem instanceof End) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + controlElem);
                }
                this.updateJobBatchStatus(JobOperator.BatchStatus.COMPLETED);
                String newExitStatus = ((End)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else if (controlElem instanceof Fail) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + controlElem);
                }
                this.updateJobBatchStatus(JobOperator.BatchStatus.FAILED);
                String newExitStatus = ((Fail)controlElem).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else {
                throw new IllegalStateException("Not sure how we'd get here but better than looping.");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
    }

    private List<StepExecution> getSplitStepExecutions(IExecutionElementController previousElementController) {
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        if (previousElementController != null) {
            SplitControllerImpl controller = (SplitControllerImpl)previousElementController;
            for (ParallelJobExecution parallelJob : controller.getParallelJobExecs()) {
                StepExecution lastStepExecution = null;
                List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(parallelJob.getJobExecution().getExecutionId());
                Iterator<StepExecution> i$ = stepExecs.iterator();
                while (i$.hasNext()) {
                    StepExecution stepExecution;
                    lastStepExecution = stepExecution = i$.next();
                }
                stepExecutions.add(lastStepExecution);
            }
        }
        return stepExecutions;
    }

    private StepExecution getLastStepExecution(Step last) {
        StepExecution lastStepExecution = null;
        List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(this.jobExecution.getExecutionId());
        for (StepExecution stepExecution : stepExecs) {
            if (!last.getId().equals(stepExecution.getName())) continue;
            lastStepExecution = stepExecution;
        }
        return lastStepExecution;
    }

    private Step getLastStepInTheFlow(ExecutionElement previousExecutionElement) {
        Flow flow = (Flow)previousExecutionElement;
        Step last = null;
        for (ExecutionElement elem : flow.getExecutionElements()) {
            if (!(elem instanceof Step)) continue;
            last = (Step)elem;
        }
        return last;
    }

    @Override
    public void stop() {
        if (this.jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTING) || this.jobContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTED)) {
            this.updateJobBatchStatus(JobOperator.BatchStatus.STOPPING);
            if (this.currentStoppableElementController != null) {
                this.currentStoppableElementController.stop();
            }
        }
    }

    private void updateJobBatchStatus(JobOperator.BatchStatus batchStatus) {
        String methodName = "updateJobBatchStatus";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(methodName + " Setting job batch status to: " + batchStatus);
        }
        this.jobContext.setBatchStatus(batchStatus);
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        switch (batchStatus) {
            case STARTING: {
                JobExecutionHelper.updateBatchStatusUPDATEonly(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STARTED: {
                JobExecutionHelper.updateBatchStatusSTART(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STOPPING: {
                JobExecutionHelper.updateBatchStatusUPDATEonly(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STOPPED: {
                JobExecutionHelper.updateBatchStatusSTOP(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case COMPLETED: {
                JobExecutionHelper.updateBatchStatusCOMPLETED(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case FAILED: {
                JobExecutionHelper.updateBatchStatusFAILED(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
        }
    }

    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }
}

