/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.batch.container.context.impl.MetricImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.impl.BatchKernelImpl;
import com.ibm.batch.container.impl.BatchletStepControllerImpl;
import com.ibm.batch.container.jobinstance.JobExecutionHelper;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.jobinstance.StepExecutionImpl;
import com.ibm.batch.container.services.IJobIdManagementService;
import com.ibm.batch.container.services.IJobStatusManagerService;
import com.ibm.batch.container.services.ITransactionManagementService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.services.TransactionManagerAdatper;
import com.ibm.batch.container.status.StepStatus;
import com.ibm.batch.container.util.PartitionDataWrapper;
import java.io.Externalizable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.runtime.JobInstance;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Step;

public abstract class BaseStepControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected RuntimeJobExecutionImpl jobExecutionImpl;
    protected JobInstance jobInstance;
    protected StepContextImpl<?, ? extends Externalizable> stepContext;
    protected Step step;
    protected StepStatus stepStatus;
    private Properties properties = new Properties();
    protected LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue = null;
    protected PartitionCollectorProxy collectorProxy = null;
    protected static BatchKernelImpl batchKernel = (BatchKernelImpl)ServicesManager.getInstance().getService(ServicesManager.ServiceType.BATCH_KERNEL_SERVICE);
    protected static IJobIdManagementService _jobIdManagementService = (IJobIdManagementService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.JOB_ID_MANAGEMENT_SERVICE);
    protected TransactionManagerAdatper transactionManager = null;
    private static IJobStatusManagerService _jobStatusService = (IJobStatusManagerService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.JOB_STATUS_MANAGEMENT_SERVICE);

    protected BaseStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.jobInstance = jobExecutionImpl.getJobInstance();
        if (step == null) {
            throw new IllegalArgumentException("Step parameter to ctor cannot be null.");
        }
        this.step = step;
    }

    private void setContextProperties() {
        JSLProperties jslProps = this.step.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.stepContext.getProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("READ_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("WRITE_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("READ_SKIP_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("PROCESS_SKIP_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("WRITE_SKIP_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("FILTER_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("COMMIT_COUNT"), 0L);
        this.stepContext.addMetric(MetricImpl.Counter.valueOf("ROLLBACK_COUNT"), 0L);
        ITransactionManagementService transMgr = (ITransactionManagementService)ServicesManager.getInstance().getService(ServicesManager.ServiceType.TRANSACTION_SERVICE);
        this.transactionManager = transMgr.getTransactionManager(this.stepContext);
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        this.stepContext = stepContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws AbortedBeforeStartException {
        Throwable throwable = null;
        this.stepStatus = _jobStatusService.getStepStatus(this.jobInstance.getInstanceId(), this.step.getId());
        try {
            RunOnRestart rc = this.preInvokeStep();
            if (rc.equals((Object)RunOnRestart.ALREADY_COMPLETE)) {
                Object dataWrapper;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Not going to run this step.  Returning previous exit status of: " + this.stepStatus.getExitStatus());
                }
                if (this.analyzerQueue != null) {
                    dataWrapper = new PartitionDataWrapper();
                    ((PartitionDataWrapper)dataWrapper).setEventType(PartitionDataWrapper.PartitionEventType.STEP_FINISHED);
                    this.analyzerQueue.add((PartitionDataWrapper)dataWrapper);
                }
                dataWrapper = this.stepStatus.getExitStatus();
                return dataWrapper;
            }
            this.invokeCoreStep();
            this.transitionToFinalStatus();
        }
        catch (Throwable t) {
            throwable = t;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(sourceClass + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            if (this.stepContext.getBatchStatus() != null) {
                this.stepContext.setBatchStatus(JobOperator.BatchStatus.FAILED);
            }
        }
        finally {
            this.invokePostStepArtifacts();
            if (this.stepContext.getBatchStatus() != null) {
                this.defaultExitStatusIfNecessary();
                this.persistStepExitStatusAndUserData();
            }
        }
        if (this.stepContext.getBatchStatus() == null) {
            throw new AbortedBeforeStartException("Thrown for stepId=" + this.step.getId());
        }
        if (throwable != null) {
            throw new RuntimeException("Wrappering earlier uncaught exception: ", throwable);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning step exitStatus: " + this.stepContext.getExitStatus());
        }
        return this.stepContext.getExitStatus();
    }

    protected abstract void invokeCoreStep() throws JobRestartException;

    protected abstract void setupStepArtifacts();

    protected abstract void invokePreStepArtifacts();

    protected abstract void invokePostStepArtifacts();

    protected void registerStepExecution() {
        long jobExecutionId = this.jobExecutionImpl.getExecutionId();
        long stepExecutionId = _jobIdManagementService.getStepExecutionId();
        this.stepContext.setStepExecutionId(stepExecutionId);
        if (this.stepStatus != null) {
            this.stepContext.setPersistentUserData(this.stepStatus.getPersistentUserData());
        }
        StepExecutionImpl stepExecution = new StepExecutionImpl(jobExecutionId, stepExecutionId);
        stepExecution.setStepName(this.step.getId());
        stepExecution.setStepContext(this.stepContext);
        if (this.stepStatus != null) {
            stepExecution.setpersistentUserData(this.stepStatus.getPersistentUserData());
        }
    }

    private void defaultExitStatusIfNecessary() {
        String stepExitStatus = this.stepContext.getExitStatus();
        if (stepExitStatus != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning with user-set exit status: " + stepExitStatus);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning with default exit status");
            }
            this.stepContext.setExitStatus(this.stepContext.getBatchStatus().name());
        }
    }

    protected void statusStarting() {
        this.stepStatus.setBatchStatus(JobOperator.BatchStatus.STARTING);
        _jobStatusService.updateJobCurrentStep(this.jobInstance.getInstanceId(), this.step.getId());
        _jobStatusService.updateEntireStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STARTING);
        long time = System.currentTimeMillis();
        Timestamp startTS = new Timestamp(time);
        this.stepContext.setStartTime(startTS);
    }

    protected void statusStarted() {
        this.stepStatus.setBatchStatus(JobOperator.BatchStatus.STARTED);
        _jobStatusService.updateEntireStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STARTED);
    }

    protected void statusStopped() {
        this.stepStatus.setBatchStatus(JobOperator.BatchStatus.STOPPED);
        _jobStatusService.updateEntireStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPED);
    }

    protected void statusCompleted() {
        this.stepStatus.setBatchStatus(JobOperator.BatchStatus.COMPLETED);
        _jobStatusService.updateEntireStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.COMPLETED);
    }

    private void transitionToFinalStatus() {
        JobOperator.BatchStatus currentBatchStatus = this.stepContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)JobOperator.BatchStatus.STARTING)) {
            throw new IllegalStateException("Step batch status should not be in a STARTING state");
        }
        if (currentBatchStatus.equals((Object)JobOperator.BatchStatus.STARTED)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transitioning step status to COMPLETED for step: " + this.step.getId());
            }
            this.statusCompleted();
        } else if (currentBatchStatus.equals((Object)JobOperator.BatchStatus.STOPPING)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transitioning step status to STOPPED for step: " + this.step.getId());
            }
            this.statusStopped();
        }
    }

    private void persistStepExitStatusAndUserData() {
        this.stepStatus.setPersistentUserData(this.stepContext.getPersistentUserData());
        this.stepStatus.setExitStatus(this.stepContext.getExitStatus());
        _jobStatusService.updateEntireStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        long time = System.currentTimeMillis();
        Timestamp endTS = new Timestamp(time);
        this.stepContext.setEndTime(endTS);
        JobExecutionHelper.persistStepExecution(this.jobExecutionImpl.getExecutionId(), this.stepContext);
    }

    protected RunOnRestart preInvokeStep() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("In preInvokeStep() with stepContext =  " + this.stepContext);
        }
        this.registerStepExecution();
        boolean runStep = true;
        if (this.stepStatus == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Exist StepStatus not found.  Creating StepStatus for (" + this.jobInstance.getInstanceId() + "," + this.step.getId() + ")");
            }
            this.stepStatus = new StepStatus(this.step.getId());
            _jobStatusService.createStepStatus(this.jobInstance.getInstanceId(), this.step.getId(), this.stepStatus);
        } else if (this.runOnRestart()) {
            this.stepStatus.incrementStartCount();
        } else {
            return RunOnRestart.ALREADY_COMPLETE;
        }
        this.statusStarting();
        this.setContextProperties();
        this.setupStepArtifacts();
        this.statusStarted();
        this.invokePreStepArtifacts();
        return RunOnRestart.RUN;
    }

    private boolean runOnRestart() {
        JobOperator.BatchStatus stepBatchStatus = this.stepStatus.getBatchStatus();
        if (stepBatchStatus.equals((Object)JobOperator.BatchStatus.COMPLETED)) {
            if (!Boolean.parseBoolean(this.step.getAllowStartIfComplete())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, so won't be run again since it does not allow start if complete.");
                }
                return false;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, and allow-start-if-complete is set to 'true'");
            }
        }
        int startLimit = 0;
        String startLimitString = this.step.getStartLimit();
        if (startLimitString != null) {
            try {
                startLimit = Integer.parseInt(startLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse start limit value for stepId: " + this.step.getId() + ", with start-limit=" + this.step.getStartLimit(), e);
            }
        }
        if (startLimit < 0) {
            throw new IllegalArgumentException("Found negative start-limit of " + startLimit + "for stepId: " + this.step.getId());
        }
        if (startLimit > 0) {
            int newStepStartCount = this.stepStatus.getStartCount() + 1;
            if (newStepStartCount > startLimit) {
                throw new IllegalArgumentException("For stepId: " + this.step.getId() + ", tried to start step for the " + newStepStartCount + " time, but startLimit = " + startLimit);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting (possibly restarting) step: " + this.step.getId() + ", since newStepStartCount = " + newStepStartCount + "and startLimit=" + startLimit);
            }
        }
        return true;
    }

    protected LinkedBlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerQueue;
    }

    @Override
    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    private static enum RunOnRestart {
        ALREADY_COMPLETE,
        RUN;

    }
}

