/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.SplitListenerProxy;
import com.ibm.batch.container.context.impl.FlowContextImpl;
import com.ibm.batch.container.context.impl.SplitContextImpl;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.BatchKernelImpl;
import com.ibm.batch.container.impl.ParallelJobBuilder;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.util.ExecutionStatus;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.Split;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobExecutionImpl jobExecutionImpl;
    protected SplitContextImpl currentSplitContext;
    private volatile List<ParallelJobExecution> parallelJobExecs;
    private final ServicesManager servicesManager;
    private final BatchKernelImpl batchKernel;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    private PartitionAnalyzerProxy analyzerProxy;
    private List<SplitListenerProxy> splitListeners = null;
    protected Split split;

    public SplitControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Split split) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.currentSplitContext = new SplitContextImpl(split.getId());
        this.split = split;
        this.servicesManager = ServicesManager.getInstance();
        this.batchKernel = (BatchKernelImpl)this.servicesManager.getService(ServicesManager.ServiceType.BATCH_KERNEL_SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelJobExecs != null) {
                for (ParallelJobExecution subJob : this.parallelJobExecs) {
                    try {
                        this.batchKernel.stopJob(subJob.getJobExecution().getInstanceId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws AbortedBeforeStartException {
        String curStatusString;
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod);
        }
        this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STARTING));
        List<Flow> flows = this.split.getFlow();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.currentSplitContext.getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
                this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
                return this.currentSplitContext.getExitStatus();
            }
            for (int instance = 0; instance < flows.size(); ++instance) {
                this.subJobs.add(ParallelJobBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.split, flows.get(instance), null, instance));
            }
            this.splitListeners = this.jobExecutionImpl.getListenerFactory().getSplitListeners(this.split);
            for (SplitListenerProxy listenerProxy : this.splitListeners) {
                listenerProxy.setJobContext(this.jobExecutionImpl.getJobContext());
                listenerProxy.setSplitContext(this.currentSplitContext);
            }
            this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STARTED));
            for (SplitListenerProxy listenerProxy : this.splitListeners) {
                listenerProxy.beforeSplit();
            }
            this.parallelJobExecs = this.batchKernel.startParallelJobs(this.subJobs, null, this.analyzerProxy);
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            subJob.waitForResult();
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            String batchStatus = subJob.getJobExecution().getJobContext().getBatchStatus();
            if (batchStatus.equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED))) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                    logger.fine("Starting logical transaction rollback.");
                }
                this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.FAILED));
                break;
            }
            if (!batchStatus.equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED))) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                logger.fine("Starting logical transaction rollback.");
            }
            this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
            break;
        }
        if ((curStatusString = this.currentSplitContext.getBatchStatus()) == null) {
            throw new IllegalStateException("Split BatchStatus should have been set by now");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceMethod, sourceMethod);
        }
        if (this.currentSplitContext.getBatchStatus().equals((Object)ExecutionStatus.BatchStatus.STARTED)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transitioning split status to COMPLETED for split: " + this.split.getId());
            }
            this.currentSplitContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.COMPLETED));
        }
        for (SplitListenerProxy listenerProxy : this.splitListeners) {
            listenerProxy.afterSplit();
        }
        if (this.currentSplitContext.getExitStatus() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning split with user-set exit status: " + this.currentSplitContext.getExitStatus());
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning split with default exit status");
            }
            this.currentSplitContext.setExitStatus(this.currentSplitContext.getBatchStatus());
        }
        return this.currentSplitContext.getExitStatus();
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setSplitContext(SplitContextImpl splitContext) {
        this.currentSplitContext = splitContext;
    }

    @Override
    public void setFlowContext(FlowContextImpl flowContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: flow context is not in scope within a split.");
    }

    @Override
    public void setAnalyzerProxy(PartitionAnalyzerProxy analyzerProxy) {
        this.analyzerProxy = analyzerProxy;
    }
}

