/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.OnSkipProcessItem;
import javax.batch.annotation.OnSkipReadItem;
import javax.batch.annotation.OnSkipWriteItem;
import jsr352.batch.jsl.Property;

public class SkipListenerProxy
extends AbstractProxy {
    private Method onSkipInReadMethod = null;
    private Method onSkipInWriteMethod = null;
    private Method onSkipInProcessMethod = null;

    SkipListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            OnSkipProcessItem onSkipInProcess;
            OnSkipWriteItem onSkipInWrite;
            OnSkipReadItem onSkipInRead = method.getAnnotation(OnSkipReadItem.class);
            if (onSkipInRead != null) {
                this.onSkipInReadMethod = method;
            }
            if ((onSkipInWrite = method.getAnnotation(OnSkipWriteItem.class)) != null) {
                this.onSkipInWriteMethod = method;
            }
            if ((onSkipInProcess = method.getAnnotation(OnSkipProcessItem.class)) == null) continue;
            this.onSkipInProcessMethod = method;
        }
    }

    public void onSkipInRead(Exception ex) {
        if (this.onSkipInReadMethod != null) {
            try {
                this.onSkipInReadMethod.invoke(this.delegate, ex);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onSkipInWrite(Exception ex, Object record) {
        if (this.onSkipInWriteMethod != null) {
            try {
                this.onSkipInWriteMethod.invoke(this.delegate, ex, record);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onSkipInProcess(Exception ex, Object record) {
        if (this.onSkipInProcessMethod != null) {
            try {
                this.onSkipInProcessMethod.invoke(this.delegate, ex, record);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

