/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.xjcl.impl;

import com.ibm.batch.container.xjcl.ModelResolverFactory;
import com.ibm.batch.container.xjcl.XJCLLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class XJCLRepository {
    private static final Map<String, JSLJob> jobMap = new HashMap<String, JSLJob>();
    private static final Map<String, Split> splitMap = new HashMap<String, Split>();
    private static final Map<String, Flow> flowMap = new HashMap<String, Flow>();
    private static final Map<String, Step> stepMap = new HashMap<String, Step>();

    public static Map<String, JSLJob> getJobMap() {
        return jobMap;
    }

    public static Map<String, Split> getSplitMap() {
        return splitMap;
    }

    public static Map<String, Flow> getFlowMap() {
        return flowMap;
    }

    public static Map<String, Step> getStepMap() {
        return stepMap;
    }

    public static JSLJob getJobID(String jobID) {
        JSLJob job = jobMap.get(jobID);
        if (job == null) {
            XJCLRepository repo;
            XJCLRepository xJCLRepository = repo = new XJCLRepository();
            xJCLRepository.getClass();
            String jobXML = xJCLRepository.new DummyXJCLLoader().loadJob(jobID);
            job = ModelResolverFactory.createJobResolver().resolveModel((JSLJob)((Object)jobXML));
            jobMap.put(jobID, job);
        }
        return job;
    }

    private class DummyXJCLLoader
    implements XJCLLoader {
        private DummyXJCLLoader() {
        }

        @Override
        public String loadXJCL(String id) {
            return null;
        }

        @Override
        public String loadJob(String id) {
            File jobFile = null;
            BufferedReader br = null;
            StringBuffer sb = new StringBuffer();
            try {
                br = new BufferedReader(new FileReader(jobFile));
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ioe) {}
            }
            return sb.toString();
        }

        @Override
        public String loadSplit(String id) {
            return null;
        }

        @Override
        public String loadFlow(String id) {
            return null;
        }

        @Override
        public String loadStep(String id) {
            return null;
        }
    }
}

