/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.Close;
import javax.batch.annotation.Open;
import javax.batch.annotation.ReadItem;
import jsr352.batch.jsl.Property;

public class ItemReaderProxy
extends AbstractProxy {
    private Method openMethod = null;
    private Method closeMethod = null;
    private Method readItemMethod = null;
    private Method checkpointInfoMethod = null;

    ItemReaderProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            CheckpointInfo checkpointInfoReader;
            ReadItem readItemReader;
            Close closeReader;
            Open openReader = method.getAnnotation(Open.class);
            if (openReader != null) {
                this.openMethod = method;
            }
            if ((closeReader = method.getAnnotation(Close.class)) != null) {
                this.closeMethod = method;
            }
            if ((readItemReader = method.getAnnotation(ReadItem.class)) != null) {
                this.readItemMethod = method;
            }
            if ((checkpointInfoReader = method.getAnnotation(CheckpointInfo.class)) == null) continue;
            this.checkpointInfoMethod = method;
        }
    }

    public void openReader(Object checkpoint) {
        if (this.openMethod != null) {
            try {
                Object[] args = new Object[]{checkpoint};
                this.openMethod.invoke(this.delegate, args);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void closeReader() {
        if (this.closeMethod != null) {
            try {
                this.closeMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public Object readItem() throws Throwable {
        Object item = null;
        if (this.readItemMethod != null) {
            try {
                item = this.readItemMethod.invoke(this.delegate, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return item;
    }

    public Object checkpointInfo() {
        Object checkpointData = null;
        if (this.checkpointInfoMethod != null) {
            try {
                checkpointData = this.checkpointInfoMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        return checkpointData;
    }

    public Method getOpenMethod() {
        return this.openMethod;
    }

    public Method getCloseMethod() {
        return this.closeMethod;
    }

    public Method getReadItemMethod() {
        return this.readItemMethod;
    }

    public Method getCheckpointInfoMethod() {
        return this.checkpointInfoMethod;
    }
}

