/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.validation;

import com.ibm.batch.container.artifact.proxy.BatchletProxy;
import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.CheckpointListenerProxy;
import com.ibm.batch.container.artifact.proxy.DeciderProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.batch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.batch.container.artifact.proxy.JobListenerProxy;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.batch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.batch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.batch.container.artifact.proxy.RetryListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipListenerProxy;
import com.ibm.batch.container.artifact.proxy.StepListenerProxy;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.io.Externalizable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.CheckpointAlgorithm;
import javax.batch.annotation.Decider;
import javax.batch.annotation.ItemProcessor;
import javax.batch.annotation.ItemReader;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.PartitionAnalyzer;
import javax.batch.annotation.PartitionCollector;
import javax.batch.annotation.PartitionMapper;
import javax.batch.annotation.PartitionReducer;

public class ArtifactSignatureValidator {
    private static final String sourceClass = ArtifactSignatureValidator.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    public static void validate(BatchletProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(Batchlet.class)) {
            throw new ArtifactValidationException(description + " does not contain a @Batchlet annotation.");
        }
        StringBuffer errorMsg = new StringBuffer(description + " has an invalid signature: \n");
        boolean valid = true;
        Method processMethod = proxy.getProcessMethod();
        if (processMethod == null) {
            errorMsg.append("  @Process-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?> returnType = processMethod.getReturnType();
            if (!String.class.equals(returnType)) {
                errorMsg.append("  @Process-annotated method return type should be java.lang.String, but was: " + returnType + ".\n");
                valid = false;
            }
        }
        if (proxy.getStopMethod() == null) {
            errorMsg.append("  @Cancel-annotated method is required, but none found.\n");
            valid = false;
        }
        if (!valid) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(errorMsg.toString());
            }
            throw new ArtifactValidationException(errorMsg.toString());
        }
    }

    public static void validate(CheckpointListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(ItemProcessorProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(ItemProcessor.class)) {
            throw new ArtifactValidationException(description + " does not contain a @ItemProcessor annotation.");
        }
        StringBuffer errorMsg = new StringBuffer(description + " has an invalid signature: \n");
        boolean valid = true;
        if (proxy.getProcessItemMethod() == null) {
            errorMsg.append("  @ProcessItem-annotated method is required, but none found.\n");
            valid = false;
        }
        if (!valid) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(errorMsg.toString());
            }
            throw new ArtifactValidationException(errorMsg.toString());
        }
    }

    public static void validate(ItemReaderProxy proxy) throws ArtifactValidationException {
        Method checkpointInfoMethod;
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(ItemReader.class)) {
            throw new ArtifactValidationException(description + " does not contain a @ItemReader annotation.");
        }
        StringBuffer errorMsg = new StringBuffer(description + " has an invalid signature: \n");
        boolean valid = true;
        Method openMethod = proxy.getOpenMethod();
        if (openMethod == null) {
            errorMsg.append("  @Open-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?>[] parmTypes = openMethod.getParameterTypes();
            if (parmTypes.length != 1) {
                errorMsg.append("  @Open-annotated method requires a single input parameter but found parm size = " + parmTypes.length + ".\n");
                valid = false;
            } else if (!Externalizable.class.isAssignableFrom(parmTypes[0])) {
                errorMsg.append("  @Open-annotated method input parameter should accept an argument implementing java.io.Externalizable.\n");
                valid = false;
            }
        }
        if (proxy.getReadItemMethod() == null) {
            errorMsg.append("  @ReadItem-annotated method is required, but none found.\n");
            valid = false;
        }
        if ((checkpointInfoMethod = proxy.getCheckpointInfoMethod()) == null) {
            errorMsg.append("  @CheckpointInfo-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?> returnType = checkpointInfoMethod.getReturnType();
            if (!Externalizable.class.isAssignableFrom(returnType)) {
                errorMsg.append("  @CheckpointInfo-annotated method return type should implement java.io.Externalizable.\n");
                valid = false;
            }
        }
        if (!valid) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(errorMsg.toString());
            }
            throw new ArtifactValidationException(errorMsg.toString());
        }
    }

    public static void validate(ItemReadListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(ItemWriteListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(ItemWriterProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(ItemWriter.class)) {
            throw new ArtifactValidationException(description + " does not contain a @ItemWriter annotation.");
        }
        StringBuffer errorMsg = new StringBuffer(description + " has an invalid signature: \n");
        boolean valid = true;
        Method openMethod = proxy.getOpenMethod();
        if (openMethod == null) {
            errorMsg.append("  @Open-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?>[] parmTypes = openMethod.getParameterTypes();
            if (parmTypes.length != 1) {
                errorMsg.append("  @Open-annotated method requires a single input parameter but found parm size = " + parmTypes.length + ".\n");
                valid = false;
            } else if (!Externalizable.class.isAssignableFrom(parmTypes[0])) {
                errorMsg.append("  @Open-annotated method input parameter should accept an argument implementing java.io.Externalizable.\n");
                valid = false;
            }
        }
        Method writeItemsMethod = proxy.getWriteItemsMethod();
        if (writeItemsMethod == null) {
            errorMsg.append("  @WriteItems-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?>[] parmTypes = writeItemsMethod.getParameterTypes();
            if (parmTypes.length != 1) {
                errorMsg.append("  @WriteItems-annotated method requires a single input parameter but found parm size = " + parmTypes.length + ".\n");
                valid = false;
            } else if (!List.class.isAssignableFrom(parmTypes[0])) {
                errorMsg.append("  @WriteItems-annotated method input parameter should accept an argument of type List<item-type>.\n");
                valid = false;
            }
        }
        Method checkpointInfoMethod = proxy.getCheckpointInfoMethod();
        if (checkpointInfoMethod == null) {
            errorMsg.append("  @CheckpointInfo-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?> returnType = checkpointInfoMethod.getReturnType();
            if (!Externalizable.class.isAssignableFrom(returnType)) {
                errorMsg.append("  @CheckpointInfo-annotated method return type should implement java.io.Externalizable.\n");
                valid = false;
            }
        }
        if (!valid) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(errorMsg.toString());
            }
            throw new ArtifactValidationException(errorMsg.toString());
        }
    }

    public static void validate(ItemProcessListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(JobListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(StepListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(DeciderProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(Decider.class)) {
            throw new ArtifactValidationException(description + " does not contain a @Decider annotation.");
        }
        StringBuffer errorMsg = new StringBuffer(description + " has an invalid signature: \n");
        boolean valid = true;
        Method decideMethod = proxy.getDecideMethod();
        if (decideMethod == null) {
            errorMsg.append("  @Decide-annotated method is required, but none found.\n");
            valid = false;
        } else {
            Class<?> returnType = decideMethod.getReturnType();
            if (!String.class.equals(returnType)) {
                errorMsg.append("  @Decide-annotated method return type should be java.lang.String, but was: " + returnType + ".\n");
                valid = false;
            }
        }
        if (!valid) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(errorMsg.toString());
            }
            throw new ArtifactValidationException(errorMsg.toString());
        }
    }

    public static void validate(CheckpointAlgorithmProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(CheckpointAlgorithm.class)) {
            throw new ArtifactValidationException(description + " does not contain a @CheckpointAlgorithm annotation.");
        }
    }

    public static void validate(PartitionAnalyzerProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(PartitionAnalyzer.class)) {
            throw new ArtifactValidationException(description + " does not contain a @SubJobAnalyzer annotation.");
        }
    }

    public static void validate(PartitionCollectorProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(PartitionCollector.class)) {
            throw new ArtifactValidationException(description + " does not contain a @SubJobCollector annotation.");
        }
    }

    public static void validate(PartitionMapperProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(PartitionMapper.class)) {
            throw new ArtifactValidationException(description + " does not contain a @PartitionMapper annotation.");
        }
    }

    public static void validate(RetryListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(SkipListenerProxy proxy) throws ArtifactValidationException {
    }

    public static void validate(PartitionReducerProxy proxy) throws ArtifactValidationException {
        Object delegate = proxy.getDelegate();
        String description = "Artifact: " + delegate + " of type: " + delegate.getClass();
        if (!delegate.getClass().isAnnotationPresent(PartitionReducer.class)) {
            throw new ArtifactValidationException(description + " does not contain a @LogicalTX annotation.");
        }
    }
}

