/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.BatchletProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.util.ExecutionStatus;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.io.Externalizable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Batchlet;
import jsr352.batch.jsl.Partition;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Step;

public class BatchletStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchletProxy proxy;

    public BatchletStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    private void invokeBatchlet(Batchlet batchlet) throws BatchContainerServiceException {
        String batchletId = batchlet.getRef();
        List<Property> propList = batchlet.getProperties() == null ? null : batchlet.getProperties().getPropertyList();
        String sourceMethod = "invokeBatchlet";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod, batchletId);
        }
        String exitStatus = null;
        try {
            this.proxy = ProxyFactory.createBatchletProxy(batchletId, propList);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the batchlet [" + batchletId + "]", e);
        }
        this.proxy.setJobContext(this.jobExecutionImpl.getJobContext());
        this.proxy.setStepContext(this.stepContext);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Batchlet is loaded and validated: " + this.proxy);
        }
        if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING))) {
            this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPED));
        } else {
            exitStatus = this.proxy.process();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("StepContext exit status set to process() return value.");
                logger.exiting(sourceClass, sourceMethod, exitStatus);
            }
            this.stepContext.setExitStatus(exitStatus);
        }
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        Partition partition = this.step.getPartition();
        if (partition != null) {
            // empty if block
        }
        this.invokeBatchlet(this.step.getBatchlet());
        if (this.collectorProxy != null) {
            Externalizable data = this.collectorProxy.collectPartitionData();
            if (this.analyzerProxy != null) {
                this.analyzerProxy.analyzeCollectorData(data);
            }
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(ExecutionStatus.getStringValue(ExecutionStatus.BatchStatus.STOPPING));
        if (this.proxy != null) {
            this.proxy.stop();
        }
    }
}

