/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.impl.BatchletStepControllerImpl;
import com.ibm.batch.container.impl.ChunkStepControllerImpl;
import com.ibm.batch.container.impl.DecisionControllerImpl;
import com.ibm.batch.container.impl.FlowControllerImpl;
import com.ibm.batch.container.impl.PartitionedStepControllerImpl;
import com.ibm.batch.container.impl.SplitControllerImpl;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.xjcl.ExecutionElement;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr352.batch.jsl.Batchlet;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.Decision;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.Split;
import jsr352.batch.jsl.Step;

public class ExecutionElementControllerFactory {
    private static final String CLASSNAME = ExecutionElementControllerFactory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);

    public static IExecutionElementController getExecutionElementController(RuntimeJobExecutionImpl jobExecutionImpl, ExecutionElement executionElement) {
        String methodName = "getExecutionElementController";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASSNAME, methodName, "Get Execution Element Controller for", executionElement.getId());
        }
        if (executionElement instanceof Step) {
            String instances;
            Step step = (Step)executionElement;
            if (step.getPartition() != null && step.getPartition().getPartitionPlan() != null && (instances = step.getPartition().getPartitionPlan().getInstances()) != null && !instances.equals("1")) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found partitioned step", step);
                }
                return new PartitionedStepControllerImpl(jobExecutionImpl, step);
            }
            Batchlet batchlet = step.getBatchlet();
            if (batchlet != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found batchlet", batchlet);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found batchlet", batchlet.getRef());
                }
                if (step.getChunk() != null) {
                    throw new IllegalArgumentException("Step contains both a batchlet and a chunk.  Aborting.");
                }
                return new BatchletStepControllerImpl(jobExecutionImpl, step);
            }
            Chunk chunk = step.getChunk();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASSNAME, methodName, "Found chunk", chunk);
            }
            if (chunk == null) {
                throw new IllegalArgumentException("Step does not contain either a batchlet or a chunk.  Aborting.");
            }
            return new ChunkStepControllerImpl(jobExecutionImpl, step);
        }
        if (executionElement instanceof Decision) {
            return new DecisionControllerImpl(jobExecutionImpl, (Decision)executionElement);
        }
        if (executionElement instanceof Flow) {
            return new FlowControllerImpl(jobExecutionImpl, (Flow)executionElement);
        }
        if (executionElement instanceof Split) {
            return new SplitControllerImpl(jobExecutionImpl, (Split)executionElement);
        }
        throw new UnsupportedOperationException("Only support steps, flows, splits, and decisions so far.");
    }
}

