/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.context.impl;

import javax.batch.runtime.Metric;

public class MetricImpl
implements Metric {
    private String name;
    private Counter counter;
    private long value;

    public MetricImpl(Counter counter, long value) {
        this.counter = counter;
        this.value = value;
    }

    public String getName() {
        return this.counter.toString();
    }

    public long getValue() {
        return this.value;
    }

    public void incValue() {
        ++this.value;
    }

    public void incValueBy(long incValue) {
        this.value += incValue;
    }

    public void decValue() {
        this.value = --this.value;
    }

    public static enum Counter {
        READ_COUNT("readCount"),
        WRITE_COUNT("writeCount"),
        COMMIT_COUNT("commitCount"),
        ROLLBACK_COUNT("rollbackCount"),
        READ_SKIP_COUNT("readSkipCount"),
        PROCESS_SKIP_COUNT("processSkipCount"),
        FILTER_COUNT("filterCount"),
        WRITE_SKIP_COUNT("writeSkipCount");

        private String name;

        private Counter(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

