/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.utils;

import android.content.Context;
import android.text.TextUtils;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.Volley;

public class VolleyUtils {
    private static RequestQueue mRequestQueue;

    private static RequestQueue getRequestQueue(Context context) {
        if (mRequestQueue == null) {
            mRequestQueue = Volley.newRequestQueue((Context)context);
        }
        return mRequestQueue;
    }

    public static <T> void addToRequestQueue(Context context, Request<T> req, String tag) {
        req.setTag((Object)(TextUtils.isEmpty((CharSequence)tag) ? VolleyLog.TAG : tag));
        req.setShouldCache(true);
        req.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 4, 1.0f));
        if (mRequestQueue == null) {
            VolleyUtils.getRequestQueue(context);
        }
        mRequestQueue.add(req);
    }

    public static void cancelPendingRequests(Context context, Object tag) {
        if (mRequestQueue == null) {
            VolleyUtils.getRequestQueue(context);
        }
        mRequestQueue.cancelAll(tag);
    }
}

