/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.content.Context;
import android.os.Build;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.hypertrack.hyperlog.HyperLog;
import com.hypertrack.hyperlog.utils.CustomGson;
import com.hypertrack.hyperlog.utils.HLDateTimeUtility;
import com.hypertrack.hyperlog.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class HLHTTPMultiPartPostRequest<T>
extends Request<T> {
    private static final String TAG = HLHTTPMultiPartPostRequest.class.getSimpleName();
    private final Gson mGson;
    private final Class<T> mResponseType;
    private final WeakReference<Response.Listener<T>> mListener;
    private Context context;
    private byte[] multiPartRequestBody;
    private String filename;
    private String packageName;
    private final HashMap<String, String> additionalHeaders;
    private static final String HEADER_ENCODING = "Content-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private final String boundary = "HyperLog -" + System.currentTimeMillis();
    private boolean mGzipEnabled = false;

    HLHTTPMultiPartPostRequest(String url, byte[] multiPartRequestBody, String filename, HashMap<String, String> additionalHeaders, Context context, Class<T> responseType, boolean compress, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(1, url, errorListener);
        this.context = context;
        this.multiPartRequestBody = compress ? this.getRequestBody(multiPartRequestBody) : multiPartRequestBody;
        this.filename = filename;
        this.mResponseType = responseType;
        this.mListener = new WeakReference<Response.Listener<Response.Listener<T>>>(listener);
        this.mGson = CustomGson.gson();
        this.additionalHeaders = additionalHeaders;
        this.packageName = context.getPackageName();
    }

    private byte[] getCompressed(byte[] requestBody) {
        if (requestBody != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(requestBody.length);
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)byteArrayOutputStream, 32);
                gzipOutputStream.write(requestBody);
                gzipOutputStream.close();
                byte[] compressed = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                this.mGzipEnabled = true;
                return compressed;
            }
            catch (Exception exception) {
                HyperLog.e(TAG, "Exception occurred while getCompressed: " + exception);
                this.mGzipEnabled = false;
            }
            catch (OutOfMemoryError error) {
                HyperLog.e(TAG, "OutOfMemory Error occurred while getCompressed: " + error);
                this.mGzipEnabled = false;
            }
        }
        return null;
    }

    private byte[] getRequestBody(byte[] requestBody) {
        byte[] compressedRequestBody = this.getCompressed(requestBody);
        if (this.mGzipEnabled) {
            HyperLog.i(TAG, "Compressed FileSize: " + compressedRequestBody.length + " Bytes");
            return compressedRequestBody;
        }
        try {
            HyperLog.i(TAG, "Compressed FileSize: " + requestBody.length + " Bytes");
            return requestBody;
        }
        catch (Exception exception) {
            HyperLog.e(TAG, "Exception occurred while getRequestBody: " + exception);
            return null;
        }
    }

    public byte[] getBody() {
        return this.multiPartRequestBody;
    }

    public static String getDecompressed(byte[] compressed) throws IOException {
        try {
            int bytesRead;
            int BUFFER_SIZE = 32;
            ByteArrayInputStream is = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
            StringBuilder string = new StringBuilder();
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                string.append(new String(data, 0, bytesRead));
            }
            gis.close();
            is.close();
            return string.toString();
        }
        catch (Exception exception) {
            HyperLog.e(TAG, "Exception occurred while getDecompressed: " + exception);
            return null;
        }
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("User-Agent", this.context.getPackageName() + " (Android " + Build.VERSION.RELEASE + ")");
        params.put("Device-Time", HLDateTimeUtility.getCurrentTime());
        params.put("Device-ID", Utils.getDeviceId(this.context));
        params.put("App-ID", this.packageName);
        params.put("Content-Disposition", "attachment; filename=" + this.filename);
        if (this.mGzipEnabled) {
            params.put(HEADER_ENCODING, ENCODING_GZIP);
        }
        if (this.additionalHeaders != null) {
            for (Map.Entry<String, String> header : this.additionalHeaders.entrySet()) {
                params.put(header.getKey(), header.getValue());
            }
        }
        return params;
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        if (volleyError == null || volleyError.networkResponse == null) {
            return super.parseNetworkError(volleyError);
        }
        try {
            String json = new String(volleyError.networkResponse.data, HttpHeaderParser.parseCharset((Map)volleyError.networkResponse.headers));
            HyperLog.i(TAG, "Status Code: " + volleyError.networkResponse.statusCode + " Data: " + json);
        }
        catch (Exception e) {
            HyperLog.e(TAG, "Exception occurred while HTTPPatchRequest parseNetworkError: " + e, e);
        }
        return super.parseNetworkError(volleyError);
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        try {
            String json = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)this.mGson.fromJson(json, this.mResponseType), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JsonSyntaxException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }

    protected void deliverResponse(T response) {
        HyperLog.i(TAG, "deliverResponse: ");
        if (this.mListener != null && this.mListener.get() != null) {
            ((Response.Listener)this.mListener.get()).onResponse(response);
        }
    }

    public String getBodyContentType() {
        return "multipart/form-data;boundary=" + this.boundary;
    }
}

