/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog;

import android.text.TextUtils;
import com.hypertrack.hyperlog.DeviceLogDataSource;
import com.hypertrack.hyperlog.DeviceLogModel;
import java.util.List;

class DeviceLogList {
    private DeviceLogDataSource mDeviceLogDataSource;

    DeviceLogList(DeviceLogDataSource mDeviceLogDataSource) {
        this.mDeviceLogDataSource = mDeviceLogDataSource;
    }

    void addDeviceLog(String deviceLog) {
        if (TextUtils.isEmpty((CharSequence)deviceLog)) {
            return;
        }
        this.mDeviceLogDataSource.addDeviceLog(deviceLog);
    }

    void clearSavedDeviceLogs() {
        this.mDeviceLogDataSource.deleteAllDeviceLogs();
    }

    List<DeviceLogModel> getDeviceLogs(int batch) {
        return this.mDeviceLogDataSource.getDeviceLogs(batch);
    }

    void clearDeviceLogs(List<DeviceLogModel> pushedDeviceLogs) {
        if (pushedDeviceLogs == null || pushedDeviceLogs.isEmpty()) {
            return;
        }
        this.mDeviceLogDataSource.deleteDeviceLog(pushedDeviceLogs);
    }

    long count() {
        return this.mDeviceLogDataSource.getDeviceLogCount();
    }

    int getDeviceLogBatchCount() {
        return this.mDeviceLogDataSource.getDeviceLogBatchCount();
    }

    void clearOldLogs(int expiryTimeInSeconds) {
        this.mDeviceLogDataSource.clearOldLogs(expiryTimeInSeconds);
    }
}

