/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.error;

import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.android.volley.ParseError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class NetworkErrorUtil {
    private static final String TAG = NetworkErrorUtil.class.getSimpleName();

    public static int getErrorCode(VolleyError error) {
        if (error == null) {
            return 151;
        }
        if (error instanceof ParseError) {
            return 154;
        }
        if (error instanceof AuthFailureError) {
            return 155;
        }
        if (error.networkResponse == null) {
            return 151;
        }
        return error.networkResponse.statusCode;
    }

    public static String getMessage(VolleyError error) {
        String errorMessage = "Something went wrong. Try again later";
        if (error == null) {
            return errorMessage;
        }
        if (!TextUtils.isEmpty((CharSequence)error.getMessage())) {
            return error.getMessage();
        }
        if (error.networkResponse == null) {
            return errorMessage;
        }
        String json = "";
        if (error.networkResponse.data != null && error.networkResponse.headers != null) {
            try {
                json = new String(error.networkResponse.data, HttpHeaderParser.parseCharset((Map)error.networkResponse.headers));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        switch (error.networkResponse.statusCode) {
            case 107: {
                errorMessage = "Network Connection disabled. Please check your network connectivity and try again.";
                break;
            }
            case 108: {
                errorMessage = "Network Connection unstable or unavailable. Please check your network connectivity and try again.";
                break;
            }
            case 400: {
                errorMessage = error.networkResponse.statusCode + ": " + "The request could not be understood by the server due to malformed syntax." + " " + json;
                break;
            }
            case 403: {
                errorMessage = error.networkResponse.statusCode + ": " + "You do not have permission to access the resource." + " " + json;
                break;
            }
            case 404: {
                errorMessage = error.networkResponse.statusCode + ": " + "Not Found: The resource does not exist." + " " + json;
                break;
            }
            case 406: {
                errorMessage = error.networkResponse.statusCode + ": " + "You requested a format that is not json." + " " + json;
                break;
            }
            case 408: {
                errorMessage = error.networkResponse.statusCode + ": " + "The request timed out. Please try again." + " " + json;
                break;
            }
            case 410: {
                errorMessage = error.networkResponse.statusCode + ": " + "The requested resource has been removed from our servers." + " " + json;
                break;
            }
            case 429: {
                errorMessage = error.networkResponse.statusCode + ": " + "You have hit the rate limit for your account." + " " + json;
                break;
            }
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                errorMessage = error.networkResponse.statusCode + ": " + "There was an error on the server and we have been notified. Try again later." + " " + json;
                break;
            }
            case 501: {
                errorMessage = error.networkResponse.statusCode + ": " + "We are temporarily offline for maintenance. Please try again later." + " " + json;
            }
        }
        return errorMessage;
    }

    public static Exception getException(VolleyError error) {
        return new RuntimeException(NetworkErrorUtil.getMessage(error));
    }

    public static boolean isInvalidTokenError(VolleyError error) {
        return error != null && error.networkResponse != null && (error.networkResponse.statusCode == 401 || error.networkResponse.statusCode == 403 || error.networkResponse.statusCode == 404);
    }

    public static boolean isInvalidTrackingSessionError(VolleyError error) {
        return error != null && error.networkResponse != null && error.networkResponse.statusCode == 409;
    }

    public static boolean isInvalidRequest(VolleyError error) {
        return error != null && error.networkResponse != null && error.networkResponse.statusCode >= 400 && error.networkResponse.statusCode < 500;
    }
}

