/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.error;

import com.android.volley.NetworkResponse;
import com.android.volley.NoConnectionError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.hypertrack.hyperlog.error.ErrorCode;
import com.hypertrack.hyperlog.error.NetworkErrorUtil;

public class ErrorResponse {
    private int errorCode;
    private String errorMessage;

    public ErrorResponse() {
        this.errorCode = 151;
        this.errorMessage = "Something went wrong. Try again later";
    }

    public ErrorResponse(String errorMessage) {
        this.errorCode = 152;
        this.errorMessage = errorMessage;
    }

    public ErrorResponse(VolleyError error) {
        this.processError(error);
    }

    public void processError(VolleyError error) {
        if (error != null) {
            NetworkResponse networkResponse;
            if (error instanceof TimeoutError || error instanceof NoConnectionError) {
                networkResponse = new NetworkResponse(108, null, null, false);
                error = new VolleyError(networkResponse);
            }
            if (error.networkResponse == null) {
                networkResponse = new NetworkResponse(153, null, null, false);
                error = new VolleyError(networkResponse);
                return;
            }
        }
        this.errorCode = NetworkErrorUtil.getErrorCode(error);
        this.errorMessage = NetworkErrorUtil.getMessage(error);
    }

    public ErrorResponse(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ErrorResponse(ErrorCode.Type type) {
        switch (type) {
            case NETWORK_DISABLED: {
                this.errorCode = 107;
                this.errorMessage = "Network Connection disabled. Please check your network connectivity and try again.";
                break;
            }
            case NETWORK_UNAVAILABLE: {
                this.errorCode = 108;
                this.errorMessage = "Network Connection unstable or unavailable. Please check your network connectivity and try again.";
                break;
            }
            default: {
                this.errorCode = 151;
                this.errorMessage = "Something went wrong. Try again later";
            }
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

