/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CustomGson {
    public static Gson gson() {
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat mDateFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        private final DateFormat mDateFormat2;
        private final DateFormat mDateFormat3;
        private final DateFormat mDateFormat4;

        private DateTypeAdapter() {
            this.mDateFormat1.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.mDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            this.mDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.mDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZZZ", Locale.US);
            this.mDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.mDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZ", Locale.US);
            this.mDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.mDateFormat1;
            synchronized (dateFormat) {
                String dateFormatAsString = this.mDateFormat1.format(date);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.mDateFormat1;
                synchronized (dateFormat) {
                    return this.mDateFormat1.parse(jsonElement.getAsString());
                }
            }
            catch (ParseException e1) {
                try {
                    DateFormat dateFormat = this.mDateFormat2;
                    synchronized (dateFormat) {
                        return this.mDateFormat2.parse(jsonElement.getAsString());
                    }
                }
                catch (ParseException e2) {
                    try {
                        DateFormat dateFormat = this.mDateFormat3;
                        synchronized (dateFormat) {
                            return this.mDateFormat3.parse(jsonElement.getAsString());
                        }
                    }
                    catch (ParseException e3) {
                        try {
                            DateFormat dateFormat = this.mDateFormat4;
                            synchronized (dateFormat) {
                                return this.mDateFormat4.parse(jsonElement.getAsString());
                            }
                        }
                        catch (Exception e4) {
                            throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e4);
                        }
                    }
                }
            }
        }
    }
}

