/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.http;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.hubspot.horizon.AsyncHttpClient;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.internal.AbstractHttpResponse;
import com.hubspot.slack.client.concurrency.MoreExecutors;
import com.hubspot.slack.client.http.CachingHttpResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class NioHttpClient
implements Closeable {
    private static final ExecutorService CALLBACK_EXECUTOR = MoreExecutors.threadPoolDaemonExecutorBuilder("NioHttpClient-Callback").setFollowThreadLocals(false).setUnbounded(true).build();
    private final AsyncHttpClient delegate;

    @Inject
    public NioHttpClient(@Assisted AsyncHttpClient delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public ListenableFuture<HttpResponse> execute(HttpRequest httpRequest) {
        return this.delegate.execute(httpRequest);
    }

    @Deprecated
    public ListenableFuture<HttpResponse> execute(HttpRequest httpRequest, HttpRequest.Options options) {
        return this.delegate.execute(httpRequest, options);
    }

    @Deprecated
    public void execute(HttpRequest httpRequest, AsyncHttpClient.Callback callback) {
        this.delegate.execute(httpRequest, callback);
    }

    @Deprecated
    public void execute(HttpRequest httpRequest, HttpRequest.Options options, AsyncHttpClient.Callback callback) {
        this.delegate.execute(httpRequest, options, callback);
    }

    public CompletableFuture<HttpResponse> executeCompletableFuture(HttpRequest request) {
        final CompletableFuture responseFuture = new CompletableFuture();
        this.execute(request, new AsyncHttpClient.Callback(){

            public void completed(HttpResponse response) {
                if (response instanceof AbstractHttpResponse) {
                    CachingHttpResponse cached = CachingHttpResponse.from((AbstractHttpResponse)response);
                    responseFuture.complete(cached);
                } else {
                    responseFuture.complete(response);
                }
            }

            public void failed(Exception ex) {
                responseFuture.completeExceptionally(ex);
            }
        });
        return responseFuture.thenApplyAsync(Function.identity(), (Executor)CALLBACK_EXECUTOR);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public static interface Factory {
        public NioHttpClient wrap(@Assisted AsyncHttpClient var1);
    }
}

