/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.dependency.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class TraversalContext {
    private static final String WILDCARD = "*";
    private final DependencyNode node;
    private final List<org.apache.maven.artifact.Artifact> path;
    private final Set<String> testScopedArtifacts;
    private final Set<Exclusion> exclusions;
    private final Map<String, Set<Exclusion>> dependencyManagementExclusions;

    private TraversalContext(DependencyNode node, List<org.apache.maven.artifact.Artifact> path, Set<String> testScopedArtifacts, Set<Exclusion> exclusions, Map<String, Set<Exclusion>> dependencyManagementExclusions) {
        this.node = node;
        this.path = Collections.unmodifiableList(path);
        this.testScopedArtifacts = Collections.unmodifiableSet(testScopedArtifacts);
        this.exclusions = Collections.unmodifiableSet(exclusions);
        this.dependencyManagementExclusions = TraversalContext.toUnmodifiableMap(dependencyManagementExclusions);
    }

    public static TraversalContext newContextFor(DependencyNode node) {
        List<org.apache.maven.artifact.Artifact> path = Collections.singletonList(node.getArtifact());
        HashSet<String> testScopedArtifacts = new HashSet<String>();
        for (DependencyNode dependency : node.getChildren()) {
            if (!"test".equals(dependency.getArtifact().getScope())) continue;
            testScopedArtifacts.add(dependency.getArtifact().getDependencyConflictId());
        }
        return new TraversalContext(node, path, testScopedArtifacts, Collections.emptySet(), Collections.emptyMap());
    }

    public TraversalContext stepInto(MavenProject project, DependencyNode node) {
        String artifactKey = node.getArtifact().getDependencyConflictId();
        ArrayList<org.apache.maven.artifact.Artifact> path = new ArrayList<org.apache.maven.artifact.Artifact>(this.path);
        path.add(node.getArtifact());
        HashMap<String, Set<Exclusion>> dependencyManagementExclusions = new HashMap<String, Set<Exclusion>>(this.dependencyManagementExclusions);
        if (project.getDependencyManagement() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                HashSet<Object> dependencyExclusions = (HashSet<Exclusion>)dependencyManagementExclusions.get(dependency.getManagementKey());
                dependencyExclusions = dependencyExclusions == null ? new HashSet<Exclusion>() : new HashSet(dependencyExclusions);
                for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
                    dependencyExclusions.add(new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), WILDCARD, WILDCARD));
                }
                dependencyManagementExclusions.put(dependency.getManagementKey(), dependencyExclusions);
            }
        }
        HashSet<Exclusion> exclusions = new HashSet<Exclusion>(this.exclusions);
        if (dependencyManagementExclusions.containsKey(artifactKey)) {
            exclusions.addAll((Collection)dependencyManagementExclusions.get(artifactKey));
        }
        for (Dependency dependency : project.getDependencies()) {
            if (!artifactKey.equals(dependency.getManagementKey())) continue;
            for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add(new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), WILDCARD, WILDCARD));
            }
        }
        return new TraversalContext(node, path, this.testScopedArtifacts, exclusions, dependencyManagementExclusions);
    }

    public TraversalContext stepInto(ArtifactDescriptorResult artifactDescriptor, DependencyNode node) {
        String artifactKey = node.getArtifact().getDependencyConflictId();
        ArrayList<org.apache.maven.artifact.Artifact> path = new ArrayList<org.apache.maven.artifact.Artifact>(this.path);
        path.add(node.getArtifact());
        HashSet<Exclusion> exclusions = new HashSet<Exclusion>(this.exclusions);
        if (this.dependencyManagementExclusions.containsKey(artifactKey)) {
            exclusions.addAll((Collection<Exclusion>)this.dependencyManagementExclusions.get(artifactKey));
        }
        for (org.eclipse.aether.graph.Dependency dependency : artifactDescriptor.getDependencies()) {
            if (!artifactKey.equals(TraversalContext.key(dependency))) continue;
            exclusions.addAll(dependency.getExclusions());
        }
        return new TraversalContext(node, path, this.testScopedArtifacts, exclusions, this.dependencyManagementExclusions);
    }

    public boolean isOverriddenToTestScope(org.eclipse.aether.graph.Dependency dependency) {
        return !this.excluded(dependency) && this.testScopedArtifacts.contains(TraversalContext.key(dependency));
    }

    public org.apache.maven.artifact.Artifact currentArtifact() {
        return this.node.getArtifact();
    }

    public List<org.apache.maven.artifact.Artifact> path() {
        return this.path;
    }

    private boolean excluded(org.eclipse.aether.graph.Dependency dependency) {
        for (Exclusion exclusion : this.exclusions) {
            if (!TraversalContext.matches(dependency, exclusion)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Set<Exclusion>> toUnmodifiableMap(Map<String, Set<Exclusion>> modifiableMap) {
        HashMap<String, Set<Exclusion>> copy = new HashMap<String, Set<Exclusion>>();
        for (Map.Entry<String, Set<Exclusion>> entry : modifiableMap.entrySet()) {
            copy.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    private static boolean matches(org.eclipse.aether.graph.Dependency dependency, Exclusion exclusion) {
        Artifact artifact = dependency.getArtifact();
        return !(!artifact.getGroupId().equals(exclusion.getGroupId()) || !artifact.getArtifactId().equals(exclusion.getArtifactId()) || !WILDCARD.equals(exclusion.getClassifier()) && !artifact.getClassifier().equals(exclusion.getClassifier()) || !WILDCARD.equals(exclusion.getExtension()) && !artifact.getExtension().equals(exclusion.getExtension()));
    }

    private static String key(org.eclipse.aether.graph.Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension();
        if (!artifact.getClassifier().isEmpty()) {
            key = key + ":" + artifact.getClassifier();
        }
        return key;
    }
}

