/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import com.huaweicloud.common.configration.dynamic.HttpClientProperties;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClientTransportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HttpClient transportHttpClient(HttpClientProperties httpClientProperties) {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager((long)httpClientProperties.getConnectionTimeToLiveInMilliSeconds(), TimeUnit.MILLISECONDS);
        pool.setDefaultMaxPerRoute(httpClientProperties.getPoolSizePerRoute());
        pool.setMaxTotal(httpClientProperties.getPoolSizeMax());
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)pool).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(httpClientProperties.getConnectTimeoutInMilliSeconds()).setConnectionRequestTimeout(httpClientProperties.getConnectionRequestTimeoutInMilliSeconds()).setSocketTimeout(httpClientProperties.getReadTimeoutInMilliSeconds()).build()).evictExpiredConnections().evictIdleConnections((long)httpClientProperties.getConnectionIdleTimeoutInMilliSeconds(), TimeUnit.MILLISECONDS).build();
    }
}

