/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.metrics;

import com.huaweicloud.common.configration.dynamic.MetricsProperties;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationMetricsLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"metrics_logger");
    private static final int CORE_SIZE = 1;
    private final MeterRegistry meterRegistry;
    private final MetricsProperties metricsProperties;
    private long lastTime = -1L;
    private final Object LOCK = new Object();
    private final Map<String, Map<String, Map<String, MetricsData>>> LOGS_MODEL = new TreeMap<String, Map<String, Map<String, MetricsData>>>();

    public InvocationMetricsLogs(MeterRegistry meterRegistry, MetricsProperties metricsProperties) {
        this.meterRegistry = meterRegistry;
        this.metricsProperties = metricsProperties;
        DefaultThreadFactory threadFactory = new DefaultThreadFactory("metrics", true);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)threadFactory);
        executorService.scheduleWithFixedDelay(this::pollLogs, 5000L, metricsProperties.getLogsInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollLogs() {
        if (this.metricsProperties.isLogsEnabled()) {
            Object object = this.LOCK;
            synchronized (object) {
                this.pollInvocationMetrics();
                this.lastTime = System.currentTimeMillis();
            }
        }
    }

    private void pollInvocationMetrics() {
        List meters = this.meterRegistry.getMeters();
        for (Meter meter : meters) {
            if (!"metrics.invocation.calls".equals(meter.getId().getName())) continue;
            DistributionSummary summary = (DistributionSummary)meter;
            Map statusModel = this.LOGS_MODEL.computeIfAbsent(summary.getId().getTag("status"), k -> new TreeMap());
            Map operationModel = statusModel.computeIfAbsent(summary.getId().getTag("name"), k -> new TreeMap());
            MetricsData metricsData = operationModel.computeIfAbsent(summary.getId().getTag("stage"), k -> new MetricsData());
            metricsData.cycleAmount = summary.totalAmount() - metricsData.lastAmount;
            metricsData.lastAmount = summary.totalAmount();
            metricsData.cycleCount = summary.count() - metricsData.lastCount;
            metricsData.lastCount = summary.count();
            HistogramSnapshot histogramSnapshot = summary.takeSnapshot();
            CountAtBucket[] countAtBuckets = histogramSnapshot.histogramCounts();
            if (metricsData.lastDistribution == null) {
                metricsData.lastDistribution = new double[countAtBuckets.length];
                metricsData.cycleDistribution = new double[countAtBuckets.length];
            }
            for (int i = 0; i < countAtBuckets.length; ++i) {
                if (i == 0) {
                    metricsData.cycleDistribution[i] = countAtBuckets[i].count() - metricsData.lastDistribution[i];
                    metricsData.lastDistribution[i] = countAtBuckets[i].count();
                    continue;
                }
                metricsData.cycleDistribution[i] = countAtBuckets[i].count() - countAtBuckets[i - 1].count() - metricsData.lastDistribution[i];
                metricsData.lastDistribution[i] = countAtBuckets[i].count() - countAtBuckets[i - 1].count();
            }
            operationModel.put(summary.getId().getTag("stage"), metricsData);
        }
        if (this.lastTime == -1L) {
            return;
        }
        StringBuilder logsBuilder = new StringBuilder();
        logsBuilder.append("[status] [operation] [stage] [requests/cycle/tps] [average] ");
        for (int i = 0; i < this.metricsProperties.getServiceLevelObjectives().size(); ++i) {
            if (i == 0) {
                logsBuilder.append("[0, ").append(this.metricsProperties.getServiceLevelObjectives().get(i)).append(") ");
                continue;
            }
            logsBuilder.append("[").append(this.metricsProperties.getServiceLevelObjectives().get(i - 1)).append(",").append(this.metricsProperties.getServiceLevelObjectives().get(i)).append(") ");
        }
        logsBuilder.append("\n");
        this.LOGS_MODEL.forEach((statusKey, statusValue) -> {
            logsBuilder.append((String)statusKey);
            logsBuilder.append(":\n");
            statusValue.forEach((operationKey, operationValue) -> {
                logsBuilder.append("  ");
                logsBuilder.append((String)operationKey);
                logsBuilder.append(":\n");
                operationValue.forEach((stageKey, stageValue) -> {
                    if (stageValue.lastCount == 0L) {
                        return;
                    }
                    logsBuilder.append("    ");
                    logsBuilder.append(this.formatMetricsData((MetricsData)stageValue));
                    logsBuilder.append(" ");
                    logsBuilder.append((String)stageKey);
                    logsBuilder.append("\n");
                });
            });
        });
        LOGGER.info(logsBuilder.toString());
    }

    private String formatMetricsData(MetricsData stageValue) {
        StringBuilder data = new StringBuilder();
        data.append("(").append(stageValue.cycleCount).append("/").append(stageValue.lastCount).append(")").append("/");
        data.append(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastTime)).append("/");
        data.append(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastTime) > 0L ? stageValue.cycleCount / TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastTime) : 0L);
        data.append(" ");
        data.append(stageValue.cycleCount > 0L ? this.nanosToMillis(stageValue.cycleAmount) / stageValue.cycleCount : 0L);
        data.append(" ");
        for (int i = 0; i < stageValue.cycleDistribution.length; ++i) {
            data.append("(").append(Double.valueOf(stageValue.cycleDistribution[i]).intValue()).append("/").append(Double.valueOf(stageValue.lastDistribution[i]).intValue()).append(")").append(" ");
        }
        return data.toString();
    }

    private long nanosToMillis(Double nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos.longValue());
    }

    static class MetricsData {
        long lastCount = 0L;
        long cycleCount = 0L;
        double lastAmount = 0.0;
        double cycleAmount = 0.0;
        double[] lastDistribution;
        double[] cycleDistribution;

        MetricsData() {
        }
    }
}

