/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.context;

import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationFinishEvent;
import com.huaweicloud.common.event.EventManager;
import java.util.HashMap;
import java.util.Map;

public class InvocationStage {
    public static final String STAGE_ALL = "all";
    public static final String STAGE_FEIGN = "feign";
    public static final String STAGE_WEB_CLIENT = "webClient";
    public static final String STAGE_GATEWAY = "gateway";
    public static final String STAGE_REST_TEMPLATE = "restTemplate";
    private final InvocationContext invocationContext;
    private final Map<String, Stage> stages = new HashMap<String, Stage>();
    private int statusCode;
    private String id;
    private long beginTime;
    private long endTime;

    public InvocationStage(InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    public String recordStageBegin(String stageName) {
        String realStageName = stageName;
        if (this.stages.get(stageName) != null) {
            realStageName = realStageName + "@";
        }
        Stage stage = new Stage();
        stage.beginTime = System.nanoTime();
        this.stages.put(realStageName, stage);
        return realStageName;
    }

    public void recordStageEnd(String stageName) {
        Stage stage = this.stages.get(stageName);
        stage.endTime = this.nanoTime();
    }

    public void begin(String id) {
        this.id = id;
        this.beginTime = this.nanoTime();
    }

    public void finish(int statusCode) {
        this.statusCode = statusCode;
        this.endTime = this.nanoTime();
        InvocationFinishEvent event = new InvocationFinishEvent(this);
        EventManager.getEventBoundedAsyncEventBus().post((Object)event);
        EventManager.getEventBus().post((Object)event);
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getId() {
        return this.id;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, Stage> getStages() {
        return this.stages;
    }

    public static class Stage {
        private long beginTime;
        private long endTime;

        public long getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(long beginTime) {
            this.beginTime = beginTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }
    }
}

