/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.context;

import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.util.HeaderUtil;

public final class InvocationContextHolder {
    public static final String SERIALIZE_KEY = "x-invocation-context";
    public static final String ATTRIBUTE_KEY = "x-invocation-context";
    private static final ThreadLocal<InvocationContext> INVOCATION_CONTEXT = new ThreadLocal();

    public static InvocationContext getOrCreateInvocationContext() {
        InvocationContext result = INVOCATION_CONTEXT.get();
        if (result == null) {
            result = new InvocationContext();
            INVOCATION_CONTEXT.set(result);
        }
        return result;
    }

    public static InvocationContext deserializeAndCreate(String context) {
        InvocationContext result = InvocationContextHolder.deserialize(context);
        INVOCATION_CONTEXT.set(result);
        return result;
    }

    public static InvocationContext deserialize(String context) {
        InvocationContext result = new InvocationContext();
        result.putContext(HeaderUtil.deserialize(context));
        return result;
    }

    public static String serialize(InvocationContext context) {
        if (context == null) {
            return "";
        }
        return HeaderUtil.serialize(context.getContext());
    }

    public static void clearInvocationContext() {
        INVOCATION_CONTEXT.set(null);
    }

    public static void setInvocationContext(InvocationContext context) {
        INVOCATION_CONTEXT.set(context);
    }
}

