/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webflux;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.event.ClosedEventListener;
import com.huaweicloud.common.event.ClosedEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.filter.OrderedWebFilter;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ShutdownHookWebFilter
implements OrderedWebFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHookWebFilter.class);
    private final ContextProperties contextProperties;
    private volatile boolean isShutDown = false;

    public ShutdownHookWebFilter(ContextProperties contextProperties, ClosedEventListener closedEventListener) {
        this.contextProperties = contextProperties;
        closedEventListener.addClosedEventProcessor(new ClosedEventProcessor(){

            @Override
            public void process() {
                ShutdownHookWebFilter.this.close();
            }

            public int getOrder() {
                return 200;
            }
        });
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.isShutDown) {
            LOGGER.warn("application is shutting down, reject request {}", (Object)exchange.getRequest().getURI());
            exchange.getResponse().setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            return Mono.empty();
        }
        return chain.filter(exchange);
    }

    private void close() {
        if (this.isShutDown) {
            return;
        }
        LOGGER.warn("application is shutting down, rejecting requests...");
        this.isShutDown = true;
        if (this.contextProperties.getWaitTimeForShutDownInMillis() > 0) {
            try {
                LOGGER.info("wait {}ms for requests done.", (Object)this.contextProperties.getWaitTimeForShutDownInMillis());
                Thread.sleep(this.contextProperties.getWaitTimeForShutDownInMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getOrder() {
        return -2147483646;
    }
}

