/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webflux;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationContextHolder;
import com.huaweicloud.common.context.InvocationStage;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.reactive.filter.OrderedWebFilter;
import org.springframework.core.env.Environment;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class InvocationContextWebFilter
implements OrderedWebFilter {
    private static final String INVOCATION_CONTEXT_ENABLED = "spring.cloud.servicecomb.context.web-flux.enabled";
    private final ContextProperties contextProperties;
    private final Environment env;

    public InvocationContextWebFilter(ContextProperties contextProperties, Environment env) {
        this.contextProperties = contextProperties;
        this.env = env;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        InvocationContext context = (Boolean)this.env.getProperty(INVOCATION_CONTEXT_ENABLED, Boolean.TYPE, (Object)true) != false ? InvocationContextHolder.deserialize(exchange.getRequest().getHeaders().getFirst("x-invocation-context")) : new InvocationContext();
        this.contextProperties.getHeaderContextMapper().forEach((k, v) -> {
            if (!StringUtils.isEmpty((String)exchange.getRequest().getHeaders().getFirst(k))) {
                context.putContext((String)v, exchange.getRequest().getHeaders().getFirst(k));
            }
        });
        this.contextProperties.getQueryContextMapper().forEach((k, v) -> {
            if (!StringUtils.isEmpty((String)((String)exchange.getRequest().getQueryParams().getFirst(k)))) {
                context.putContext((String)v, (String)exchange.getRequest().getQueryParams().getFirst(k));
            }
        });
        if (context.getContext("x-trace-id") == null) {
            context.putContext("x-trace-id", InvocationContext.generateTraceId());
        }
        exchange.getAttributes().put("x-invocation-context", context);
        InvocationStage stage = context.getInvocationStage();
        stage.begin(this.buildId(exchange.getRequest(), context));
        return chain.filter(exchange).doOnSuccess(v -> this.postProcess(exchange, null)).doOnError(e -> this.postProcess(exchange, (Throwable)e));
    }

    private void postProcess(ServerWebExchange exchange, Throwable e) {
        InvocationStage stage = ((InvocationContext)exchange.getAttribute("x-invocation-context")).getInvocationStage();
        if (e instanceof ResponseStatusException) {
            stage.finish(((ResponseStatusException)e).getRawStatusCode());
            return;
        }
        stage.finish(exchange.getResponse().getStatusCode() == null ? -1 : exchange.getResponse().getStatusCode().value());
    }

    private String buildId(ServerHttpRequest request, InvocationContext context) {
        if (this.contextProperties.isUseContextOperationForMetrics()) {
            if (context.getContext("x-operation-id") != null) {
                return context.getContext("x-operation-id");
            }
            String id = this.buildOperation(request);
            context.putContext("x-operation-id", id);
            return id;
        }
        return this.buildOperation(request);
    }

    private String buildOperation(ServerHttpRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getMethod());
        sb.append(" ");
        sb.append(request.getURI().getPath());
        return sb.toString();
    }
}

