/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.web;

import com.huaweicloud.common.adapters.web.DecorateClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.InvocationContextClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.MetricsClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.PostClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.PreClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.RestTemplateAddServiceNameContext;
import com.huaweicloud.common.adapters.web.SerializeContextClientHttpRequestInterceptor;
import com.huaweicloud.common.configration.dynamic.ContextProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.http.client.ClientHttpRequestInterceptor;

@Configuration
@ConditionalOnClass(name={"org.springframework.http.client.ClientHttpRequestInterceptor", "org.springframework.web.client.RestTemplate"})
@ConditionalOnProperty(value={"spring.cloud.servicecomb.restTemplate.context.enabled"}, havingValue="true", matchIfMissing=true)
public class WebConfiguration {
    @Bean
    public ClientHttpRequestInterceptor decorateClientHttpRequestInterceptor(@Autowired(required=false) List<PreClientHttpRequestInterceptor> preClientHttpRequestInterceptors, @Autowired(required=false) List<PostClientHttpRequestInterceptor> postClientHttpRequestInterceptors) {
        return new DecorateClientHttpRequestInterceptor(preClientHttpRequestInterceptors, postClientHttpRequestInterceptors);
    }

    @Bean
    public ClientHttpRequestInterceptor invocationContextClientHttpRequestInterceptor(ContextProperties contextProperties) {
        return new InvocationContextClientHttpRequestInterceptor(contextProperties);
    }

    @Bean
    public ClientHttpRequestInterceptor metricsClientHttpRequestInterceptor() {
        return new MetricsClientHttpRequestInterceptor();
    }

    @Bean
    public ClientHttpRequestInterceptor serializeContextClientHttpRequestInterceptor() {
        return new SerializeContextClientHttpRequestInterceptor();
    }

    @Bean
    public ClientHttpRequestInterceptor restTemplateAddServiceNameContext(@Autowired(required=false) Registration registration) {
        return new RestTemplateAddServiceNameContext(registration);
    }

    @Bean
    public RestTemplateCustomizer restTemplateCustomizer(List<ClientHttpRequestInterceptor> interceptors) {
        return restTemplate -> {
            ArrayList<Object> nonOrderedList = new ArrayList<Object>();
            ArrayList<ClientHttpRequestInterceptor> orderedList = new ArrayList<ClientHttpRequestInterceptor>();
            LoadBalancerInterceptor loadBalancerInterceptor = null;
            for (ClientHttpRequestInterceptor interceptor : interceptors) {
                if (interceptor instanceof LoadBalancerInterceptor) {
                    loadBalancerInterceptor = (LoadBalancerInterceptor)interceptor;
                    continue;
                }
                if (interceptor instanceof Ordered) {
                    orderedList.add(interceptor);
                    continue;
                }
                nonOrderedList.add(interceptor);
            }
            orderedList.sort(Comparator.comparingInt(a -> ((Ordered)a).getOrder()));
            if (loadBalancerInterceptor != null) {
                nonOrderedList.add(loadBalancerInterceptor);
            }
            nonOrderedList.addAll(orderedList);
            restTemplate.setInterceptors(new ArrayList());
            restTemplate.getInterceptors().addAll(nonOrderedList);
        };
    }
}

