/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.web;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationContextHolder;
import java.io.IOException;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class InvocationContextClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    private final ContextProperties contextProperties;

    public InvocationContextClientHttpRequestInterceptor(ContextProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (!this.contextProperties.isAddTraceIdForTemplate()) {
            return execution.execute(request, body);
        }
        InvocationContext context = InvocationContextHolder.getOrCreateInvocationContext();
        if (context.getContext("x-trace-id") == null) {
            context.putContext("x-trace-id", InvocationContext.generateTraceId());
        }
        return execution.execute(request, body);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

