/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.web;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;

public class FallbackClientHttpResponse
extends AbstractClientHttpResponse {
    private final int code;
    private final String message;
    private final String contentType;

    public FallbackClientHttpResponse(int code, String message) {
        this.code = code;
        this.message = message;
        this.contentType = "application/text";
    }

    public FallbackClientHttpResponse(int code, String message, String contentType) {
        this.code = code;
        this.message = message;
        this.contentType = contentType;
    }

    public FallbackClientHttpResponse(int code) {
        this.code = code;
        this.message = null;
        this.contentType = "application/json";
    }

    public int getRawStatusCode() {
        return this.code;
    }

    public String getStatusText() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    public void close() {
    }

    public InputStream getBody() {
        if (this.message == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.message.getBytes(StandardCharsets.UTF_8));
    }

    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", this.contentType);
        return httpHeaders;
    }
}

