/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.gateway;

import com.huaweicloud.common.adapters.gateway.GatewayAddServiceNameContext;
import com.huaweicloud.common.adapters.gateway.GatewayMetricsGlobalFilter;
import com.huaweicloud.common.adapters.gateway.SerializeContextGlobalFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
@ConditionalOnProperty(value={"spring.cloud.servicecomb.gateway.context.enabled"}, havingValue="true", matchIfMissing=true)
public class GatewayConfiguration {
    @Bean
    public GlobalFilter serializeContextGlobalFilter() {
        return new SerializeContextGlobalFilter();
    }

    @Bean
    public GlobalFilter gatewayMetricsGlobalFilter() {
        return new GatewayMetricsGlobalFilter();
    }

    @Bean
    public GlobalFilter gatewayAddServiceNameContext(@Autowired(required=false) Registration registration) {
        return new GatewayAddServiceNameContext(registration);
    }
}

