/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.gateway;

import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.disovery.InstanceIDAdapter;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayAddServiceNameContext
implements GlobalFilter,
Ordered {
    private final Registration registration;

    public GatewayAddServiceNameContext(Registration registration) {
        this.registration = registration;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (this.registration == null) {
            return chain.filter(exchange);
        }
        InvocationContext context = (InvocationContext)exchange.getAttribute("x-invocation-context");
        context.putContext("x-microservice-name", this.registration.getServiceId());
        context.putContext("x-instance-id", InstanceIDAdapter.instanceId(this.registration));
        return chain.filter(exchange);
    }

    public int getOrder() {
        return 10170;
    }
}

