/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.feign;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.core.Ordered;

public class InvocationContextRequestInterceptor
implements RequestInterceptor,
Ordered {
    private final ContextProperties contextProperties;

    public InvocationContextRequestInterceptor(ContextProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    public void apply(RequestTemplate requestTemplate) {
        if (!this.contextProperties.isAddTraceIdForFeign()) {
            return;
        }
        InvocationContext context = InvocationContextHolder.getOrCreateInvocationContext();
        if (context.getContext("x-trace-id") == null) {
            context.putContext("x-trace-id", InvocationContext.generateTraceId());
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

