/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.feign;

import com.huaweicloud.common.adapters.feign.DecorateRequestInterceptor;
import com.huaweicloud.common.adapters.feign.FeignAddServiceNameContext;
import com.huaweicloud.common.adapters.feign.InvocationContextRequestInterceptor;
import com.huaweicloud.common.adapters.feign.OrderedRequestInterceptor;
import com.huaweicloud.common.adapters.feign.SerializeContextOrderedRequestInterceptor;
import com.huaweicloud.common.configration.dynamic.ContextProperties;
import feign.RequestInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"feign.RequestInterceptor"})
@ConditionalOnProperty(value={"spring.cloud.servicecomb.feign.context.enabled"}, havingValue="true", matchIfMissing=true)
public class FeignConfiguration {
    @Bean
    public RequestInterceptor decorateRequestInterceptor(List<OrderedRequestInterceptor> orderedRequestInterceptors) {
        return new DecorateRequestInterceptor(orderedRequestInterceptors);
    }

    @Bean
    public RequestInterceptor invocationContextRequestInterceptor(ContextProperties contextProperties) {
        return new InvocationContextRequestInterceptor(contextProperties);
    }

    @Bean
    public RequestInterceptor serializeContextOrderedRequestInterceptor() {
        return new SerializeContextOrderedRequestInterceptor();
    }

    @Bean
    public FeignAddServiceNameContext feignAddServiceNameContext(@Autowired(required=false) Registration registration) {
        return new FeignAddServiceNameContext(registration);
    }
}

