/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cloudrtc.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AppState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="state")
    private StateEnum state;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="update_time")
    private String updateTime;

    public AppState withState(StateEnum state) {
        this.state = state;
        return this;
    }

    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public AppState withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppState appState = (AppState)o;
        return Objects.equals(this.state, appState.state) && Objects.equals(this.updateTime, appState.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.updateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppState {\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StateEnum {
        public static final StateEnum ACTIVATION = new StateEnum("ACTIVATION");
        public static final StateEnum DEACTIVATION = new StateEnum("DEACTIVATION");
        public static final StateEnum ARREARS = new StateEnum("ARREARS");
        public static final StateEnum DELETED = new StateEnum("DELETED");
        private static final Map<String, StateEnum> STATIC_FIELDS = StateEnum.createStaticFields();
        private String value;

        private static Map<String, StateEnum> createStaticFields() {
            HashMap<String, StateEnum> map = new HashMap<String, StateEnum>();
            map.put("ACTIVATION", ACTIVATION);
            map.put("DEACTIVATION", DEACTIVATION);
            map.put("ARREARS", ARREARS);
            map.put("DELETED", DELETED);
            return Collections.unmodifiableMap(map);
        }

        StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            StateEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new StateEnum(value);
            }
            return result;
        }

        public static StateEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            StateEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof StateEnum) {
                return this.value.equals(((StateEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

