/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cloudrtc.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cloudrtc.v2.model.AppAuth;
import com.huaweicloud.sdk.cloudrtc.v2.model.AppAutoRecordMode;
import com.huaweicloud.sdk.cloudrtc.v2.model.AppCallbacks;
import com.huaweicloud.sdk.cloudrtc.v2.model.AppState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class App {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_name")
    private String appName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_id")
    private String appId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="state")
    private AppState state;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="scope")
    private ScopeEnum scope;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tenant_name")
    private String tenantName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain")
    private String domain;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="create_time")
    private String createTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    private AppAuth authentication;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="callbacks")
    private AppCallbacks callbacks;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auto_record_mode")
    private AppAutoRecordMode autoRecordMode;

    public App withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public App withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public App withState(AppState state) {
        this.state = state;
        return this;
    }

    public App withState(Consumer<AppState> stateSetter) {
        if (this.state == null) {
            this.state = new AppState();
            stateSetter.accept(this.state);
        }
        return this;
    }

    public AppState getState() {
        return this.state;
    }

    public void setState(AppState state) {
        this.state = state;
    }

    public App withScope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public App withTenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public App withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public App withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public App withAuthentication(AppAuth authentication) {
        this.authentication = authentication;
        return this;
    }

    public App withAuthentication(Consumer<AppAuth> authenticationSetter) {
        if (this.authentication == null) {
            this.authentication = new AppAuth();
            authenticationSetter.accept(this.authentication);
        }
        return this;
    }

    public AppAuth getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AppAuth authentication) {
        this.authentication = authentication;
    }

    public App withCallbacks(AppCallbacks callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public App withCallbacks(Consumer<AppCallbacks> callbacksSetter) {
        if (this.callbacks == null) {
            this.callbacks = new AppCallbacks();
            callbacksSetter.accept(this.callbacks);
        }
        return this;
    }

    public AppCallbacks getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(AppCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public App withAutoRecordMode(AppAutoRecordMode autoRecordMode) {
        this.autoRecordMode = autoRecordMode;
        return this;
    }

    public App withAutoRecordMode(Consumer<AppAutoRecordMode> autoRecordModeSetter) {
        if (this.autoRecordMode == null) {
            this.autoRecordMode = new AppAutoRecordMode();
            autoRecordModeSetter.accept(this.autoRecordMode);
        }
        return this;
    }

    public AppAutoRecordMode getAutoRecordMode() {
        return this.autoRecordMode;
    }

    public void setAutoRecordMode(AppAutoRecordMode autoRecordMode) {
        this.autoRecordMode = autoRecordMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        App app = (App)o;
        return Objects.equals(this.appName, app.appName) && Objects.equals(this.appId, app.appId) && Objects.equals(this.state, app.state) && Objects.equals(this.scope, app.scope) && Objects.equals(this.tenantName, app.tenantName) && Objects.equals(this.domain, app.domain) && Objects.equals(this.createTime, app.createTime) && Objects.equals(this.authentication, app.authentication) && Objects.equals(this.callbacks, app.callbacks) && Objects.equals(this.autoRecordMode, app.autoRecordMode);
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.appId, this.state, this.scope, this.tenantName, this.domain, this.createTime, this.authentication, this.callbacks, this.autoRecordMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class App {\n");
        sb.append("    appName: ").append(this.toIndentedString(this.appName)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tenantName: ").append(this.toIndentedString(this.tenantName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    callbacks: ").append(this.toIndentedString(this.callbacks)).append("\n");
        sb.append("    autoRecordMode: ").append(this.toIndentedString(this.autoRecordMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ScopeEnum {
        public static final ScopeEnum DOMESTIC = new ScopeEnum("DOMESTIC");
        public static final ScopeEnum OVERSEA = new ScopeEnum("OVERSEA");
        public static final ScopeEnum GLOBAL = new ScopeEnum("GLOBAL");
        private static final Map<String, ScopeEnum> STATIC_FIELDS = ScopeEnum.createStaticFields();
        private String value;

        private static Map<String, ScopeEnum> createStaticFields() {
            HashMap<String, ScopeEnum> map = new HashMap<String, ScopeEnum>();
            map.put("DOMESTIC", DOMESTIC);
            map.put("OVERSEA", OVERSEA);
            map.put("GLOBAL", GLOBAL);
            return Collections.unmodifiableMap(map);
        }

        ScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            ScopeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new ScopeEnum(value);
            }
            return result;
        }

        public static ScopeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            ScopeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScopeEnum) {
                return this.value.equals(((ScopeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

