package com.huaweicloud.sdk.cloudrtc.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.core.SdkResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

/** Response Object */
public class ListRtcClientQosDetailsResponse extends SdkResponse {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "room_id")

    private String roomId;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "data")

    private List<QosQualityData> data = null;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-id")

    private String xRequestId;

    public ListRtcClientQosDetailsResponse withRoomId(String roomId) {
        this.roomId = roomId;
        return this;
    }

    /** 房间ID
     * 
     * @return roomId */
    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public ListRtcClientQosDetailsResponse withData(List<QosQualityData> data) {
        this.data = data;
        return this;
    }

    public ListRtcClientQosDetailsResponse addDataItem(QosQualityData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<>();
        }
        this.data.add(dataItem);
        return this;
    }

    public ListRtcClientQosDetailsResponse withData(Consumer<List<QosQualityData>> dataSetter) {
        if (this.data == null) {
            this.data = new ArrayList<>();
        }
        dataSetter.accept(this.data);
        return this;
    }

    /** QoS质量数据
     * 
     * @return data */
    public List<QosQualityData> getData() {
        return data;
    }

    public void setData(List<QosQualityData> data) {
        this.data = data;
    }

    public ListRtcClientQosDetailsResponse withXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
        return this;
    }

    /** Get xRequestId
     * 
     * @return xRequestId */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-id")
    public String getXRequestId() {
        return xRequestId;
    }

    public void setXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListRtcClientQosDetailsResponse listRtcClientQosDetailsResponse = (ListRtcClientQosDetailsResponse) o;
        return Objects.equals(this.roomId, listRtcClientQosDetailsResponse.roomId)
            && Objects.equals(this.data, listRtcClientQosDetailsResponse.data)
            && Objects.equals(this.xRequestId, listRtcClientQosDetailsResponse.xRequestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roomId, data, xRequestId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListRtcClientQosDetailsResponse {\n");
        sb.append("    roomId: ").append(toIndentedString(roomId)).append("\n");
        sb.append("    data: ").append(toIndentedString(data)).append("\n");
        sb.append("    xRequestId: ").append(toIndentedString(xRequestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /** Convert the given object to string with each line indented by 4 spaces (except the first line). */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
