package com.huaweicloud.sdk.cloudrtc.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.core.SdkResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

/** Response Object */
public class ListRtcAbnormalEventsResponse extends SdkResponse {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "total")

    private Integer total;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "events")

    private List<AbnormalEvent> events = null;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-id")

    private String xRequestId;

    public ListRtcAbnormalEventsResponse withTotal(Integer total) {
        this.total = total;
        return this;
    }

    /** 异常总数 minimum: 0 maximum: 2147483647
     * 
     * @return total */
    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public ListRtcAbnormalEventsResponse withEvents(List<AbnormalEvent> events) {
        this.events = events;
        return this;
    }

    public ListRtcAbnormalEventsResponse addEventsItem(AbnormalEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<>();
        }
        this.events.add(eventsItem);
        return this;
    }

    public ListRtcAbnormalEventsResponse withEvents(Consumer<List<AbnormalEvent>> eventsSetter) {
        if (this.events == null) {
            this.events = new ArrayList<>();
        }
        eventsSetter.accept(this.events);
        return this;
    }

    /** 异常体验列表
     * 
     * @return events */
    public List<AbnormalEvent> getEvents() {
        return events;
    }

    public void setEvents(List<AbnormalEvent> events) {
        this.events = events;
    }

    public ListRtcAbnormalEventsResponse withXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
        return this;
    }

    /** Get xRequestId
     * 
     * @return xRequestId */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-id")
    public String getXRequestId() {
        return xRequestId;
    }

    public void setXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListRtcAbnormalEventsResponse listRtcAbnormalEventsResponse = (ListRtcAbnormalEventsResponse) o;
        return Objects.equals(this.total, listRtcAbnormalEventsResponse.total)
            && Objects.equals(this.events, listRtcAbnormalEventsResponse.events)
            && Objects.equals(this.xRequestId, listRtcAbnormalEventsResponse.xRequestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, events, xRequestId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListRtcAbnormalEventsResponse {\n");
        sb.append("    total: ").append(toIndentedString(total)).append("\n");
        sb.append("    events: ").append(toIndentedString(events)).append("\n");
        sb.append("    xRequestId: ").append(toIndentedString(xRequestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /** Convert the given object to string with each line indented by 4 spaces (except the first line). */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
