/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cloudrtc.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cloudrtc.v2.model.HLSRecordConfig;
import com.huaweicloud.sdk.cloudrtc.v2.model.MP4RecordConfig;
import com.huaweicloud.sdk.cloudrtc.v2.model.RecordObsFileAddr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RecordRuleReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="obs_addr")
    private RecordObsFileAddr obsAddr;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="record_formats")
    private List<RecordFormatsEnum> recordFormats = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hls_config")
    private HLSRecordConfig hlsConfig;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="mp4_config")
    private MP4RecordConfig mp4Config;

    public RecordRuleReq withObsAddr(RecordObsFileAddr obsAddr) {
        this.obsAddr = obsAddr;
        return this;
    }

    public RecordRuleReq withObsAddr(Consumer<RecordObsFileAddr> obsAddrSetter) {
        if (this.obsAddr == null) {
            this.obsAddr = new RecordObsFileAddr();
            obsAddrSetter.accept(this.obsAddr);
        }
        return this;
    }

    public RecordObsFileAddr getObsAddr() {
        return this.obsAddr;
    }

    public void setObsAddr(RecordObsFileAddr obsAddr) {
        this.obsAddr = obsAddr;
    }

    public RecordRuleReq withRecordFormats(List<RecordFormatsEnum> recordFormats) {
        this.recordFormats = recordFormats;
        return this;
    }

    public RecordRuleReq addRecordFormatsItem(RecordFormatsEnum recordFormatsItem) {
        if (this.recordFormats == null) {
            this.recordFormats = new ArrayList<RecordFormatsEnum>();
        }
        this.recordFormats.add(recordFormatsItem);
        return this;
    }

    public RecordRuleReq withRecordFormats(Consumer<List<RecordFormatsEnum>> recordFormatsSetter) {
        if (this.recordFormats == null) {
            this.recordFormats = new ArrayList<RecordFormatsEnum>();
        }
        recordFormatsSetter.accept(this.recordFormats);
        return this;
    }

    public List<RecordFormatsEnum> getRecordFormats() {
        return this.recordFormats;
    }

    public void setRecordFormats(List<RecordFormatsEnum> recordFormats) {
        this.recordFormats = recordFormats;
    }

    public RecordRuleReq withHlsConfig(HLSRecordConfig hlsConfig) {
        this.hlsConfig = hlsConfig;
        return this;
    }

    public RecordRuleReq withHlsConfig(Consumer<HLSRecordConfig> hlsConfigSetter) {
        if (this.hlsConfig == null) {
            this.hlsConfig = new HLSRecordConfig();
            hlsConfigSetter.accept(this.hlsConfig);
        }
        return this;
    }

    public HLSRecordConfig getHlsConfig() {
        return this.hlsConfig;
    }

    public void setHlsConfig(HLSRecordConfig hlsConfig) {
        this.hlsConfig = hlsConfig;
    }

    public RecordRuleReq withMp4Config(MP4RecordConfig mp4Config) {
        this.mp4Config = mp4Config;
        return this;
    }

    public RecordRuleReq withMp4Config(Consumer<MP4RecordConfig> mp4ConfigSetter) {
        if (this.mp4Config == null) {
            this.mp4Config = new MP4RecordConfig();
            mp4ConfigSetter.accept(this.mp4Config);
        }
        return this;
    }

    public MP4RecordConfig getMp4Config() {
        return this.mp4Config;
    }

    public void setMp4Config(MP4RecordConfig mp4Config) {
        this.mp4Config = mp4Config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordRuleReq recordRuleReq = (RecordRuleReq)o;
        return Objects.equals(this.obsAddr, recordRuleReq.obsAddr) && Objects.equals(this.recordFormats, recordRuleReq.recordFormats) && Objects.equals(this.hlsConfig, recordRuleReq.hlsConfig) && Objects.equals(this.mp4Config, recordRuleReq.mp4Config);
    }

    public int hashCode() {
        return Objects.hash(this.obsAddr, this.recordFormats, this.hlsConfig, this.mp4Config);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordRuleReq {\n");
        sb.append("    obsAddr: ").append(this.toIndentedString(this.obsAddr)).append("\n");
        sb.append("    recordFormats: ").append(this.toIndentedString(this.recordFormats)).append("\n");
        sb.append("    hlsConfig: ").append(this.toIndentedString(this.hlsConfig)).append("\n");
        sb.append("    mp4Config: ").append(this.toIndentedString(this.mp4Config)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class RecordFormatsEnum {
        public static final RecordFormatsEnum HLS = new RecordFormatsEnum("HLS");
        public static final RecordFormatsEnum MP4 = new RecordFormatsEnum("MP4");
        private static final Map<String, RecordFormatsEnum> STATIC_FIELDS = RecordFormatsEnum.createStaticFields();
        private String value;

        private static Map<String, RecordFormatsEnum> createStaticFields() {
            HashMap<String, RecordFormatsEnum> map = new HashMap<String, RecordFormatsEnum>();
            map.put("HLS", HLS);
            map.put("MP4", MP4);
            return Collections.unmodifiableMap(map);
        }

        RecordFormatsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecordFormatsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            RecordFormatsEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new RecordFormatsEnum(value);
            }
            return result;
        }

        public static RecordFormatsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            RecordFormatsEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecordFormatsEnum) {
                return this.value.equals(((RecordFormatsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

