package com.huaweicloud.sdk.cloudrtc.v2.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.core.SdkResponse;

import java.util.Objects;
import java.util.function.Consumer;

/** Response Object */
public class UpdateUrlAuthResponse extends SdkResponse {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "app_id")

    private String appId;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "authentication")

    private AppAuth authentication;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-Id")

    private String xRequestId;

    public UpdateUrlAuthResponse withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /** 应用id
     * 
     * @return appId */
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public UpdateUrlAuthResponse withAuthentication(AppAuth authentication) {
        this.authentication = authentication;
        return this;
    }

    public UpdateUrlAuthResponse withAuthentication(Consumer<AppAuth> authenticationSetter) {
        if (this.authentication == null) {
            this.authentication = new AppAuth();
            authenticationSetter.accept(this.authentication);
        }

        return this;
    }

    /** Get authentication
     * 
     * @return authentication */
    public AppAuth getAuthentication() {
        return authentication;
    }

    public void setAuthentication(AppAuth authentication) {
        this.authentication = authentication;
    }

    public UpdateUrlAuthResponse withXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
        return this;
    }

    /** Get xRequestId
     * 
     * @return xRequestId */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "X-request-Id")
    public String getXRequestId() {
        return xRequestId;
    }

    public void setXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateUrlAuthResponse updateUrlAuthResponse = (UpdateUrlAuthResponse) o;
        return Objects.equals(this.appId, updateUrlAuthResponse.appId)
            && Objects.equals(this.authentication, updateUrlAuthResponse.authentication)
            && Objects.equals(this.xRequestId, updateUrlAuthResponse.xRequestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, authentication, xRequestId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUrlAuthResponse {\n");
        sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
        sb.append("    authentication: ").append(toIndentedString(authentication)).append("\n");
        sb.append("    xRequestId: ").append(toIndentedString(xRequestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /** Convert the given object to string with each line indented by 4 spaces (except the first line). */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
