/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cloudrtc.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AppCallbackUrl {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="url")
    private String url;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_key")
    private String authKey;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="notify_event_subscription")
    private List<NotifyEventSubscriptionEnum> notifyEventSubscription = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="update_time")
    private String updateTime;

    public AppCallbackUrl withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AppCallbackUrl withAuthKey(String authKey) {
        this.authKey = authKey;
        return this;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public AppCallbackUrl withNotifyEventSubscription(List<NotifyEventSubscriptionEnum> notifyEventSubscription) {
        this.notifyEventSubscription = notifyEventSubscription;
        return this;
    }

    public AppCallbackUrl addNotifyEventSubscriptionItem(NotifyEventSubscriptionEnum notifyEventSubscriptionItem) {
        if (this.notifyEventSubscription == null) {
            this.notifyEventSubscription = new ArrayList<NotifyEventSubscriptionEnum>();
        }
        this.notifyEventSubscription.add(notifyEventSubscriptionItem);
        return this;
    }

    public AppCallbackUrl withNotifyEventSubscription(Consumer<List<NotifyEventSubscriptionEnum>> notifyEventSubscriptionSetter) {
        if (this.notifyEventSubscription == null) {
            this.notifyEventSubscription = new ArrayList<NotifyEventSubscriptionEnum>();
        }
        notifyEventSubscriptionSetter.accept(this.notifyEventSubscription);
        return this;
    }

    public List<NotifyEventSubscriptionEnum> getNotifyEventSubscription() {
        return this.notifyEventSubscription;
    }

    public void setNotifyEventSubscription(List<NotifyEventSubscriptionEnum> notifyEventSubscription) {
        this.notifyEventSubscription = notifyEventSubscription;
    }

    public AppCallbackUrl withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppCallbackUrl appCallbackUrl = (AppCallbackUrl)o;
        return Objects.equals(this.url, appCallbackUrl.url) && Objects.equals(this.authKey, appCallbackUrl.authKey) && Objects.equals(this.notifyEventSubscription, appCallbackUrl.notifyEventSubscription) && Objects.equals(this.updateTime, appCallbackUrl.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.authKey, this.notifyEventSubscription, this.updateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppCallbackUrl {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    authKey: ").append(this.toIndentedString(this.authKey)).append("\n");
        sb.append("    notifyEventSubscription: ").append(this.toIndentedString(this.notifyEventSubscription)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class NotifyEventSubscriptionEnum {
        public static final NotifyEventSubscriptionEnum RECORD_NEW_FILE_START = new NotifyEventSubscriptionEnum("RECORD_NEW_FILE_START");
        public static final NotifyEventSubscriptionEnum RECORD_FILE_COMPLETE = new NotifyEventSubscriptionEnum("RECORD_FILE_COMPLETE");
        private static final Map<String, NotifyEventSubscriptionEnum> STATIC_FIELDS = NotifyEventSubscriptionEnum.createStaticFields();
        private String value;

        private static Map<String, NotifyEventSubscriptionEnum> createStaticFields() {
            HashMap<String, NotifyEventSubscriptionEnum> map = new HashMap<String, NotifyEventSubscriptionEnum>();
            map.put("RECORD_NEW_FILE_START", RECORD_NEW_FILE_START);
            map.put("RECORD_FILE_COMPLETE", RECORD_FILE_COMPLETE);
            return Collections.unmodifiableMap(map);
        }

        NotifyEventSubscriptionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NotifyEventSubscriptionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            NotifyEventSubscriptionEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new NotifyEventSubscriptionEnum(value);
            }
            return result;
        }

        public static NotifyEventSubscriptionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            NotifyEventSubscriptionEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof NotifyEventSubscriptionEnum) {
                return this.value.equals(((NotifyEventSubscriptionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

