/*
 * Decompiled with CFR 0.152.
 */
package com.hs.progressbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.hs.progressbutton.CustomImageView;
import com.hs.progressbutton.CustomProgressBar;
import com.hs.progressbutton.R;

public class ProgressImageView
extends FrameLayout {
    public static final int DEFAULT_RADIUS = 75;
    public static final int DEFAULT_THICKNESS = 3;
    public static final int DEFAULT_RING_COLOR = Color.parseColor((String)"#ffff00ff");
    private ProgressState progressState;
    private int completeRingColor = -1;
    private CustomProgressBar mProgressBar;
    private CustomImageView mImageView;

    public ProgressImageView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ProgressImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ProgressImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ProgressImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    void init(Context context, AttributeSet attrs) {
        int width = ProgressImageView.dpToPx(context, 75);
        int thickness = ProgressImageView.dpToPx(context, 3);
        int ringColor = 0;
        int startImage = 0;
        int endImage = 0;
        int progressImage = 0;
        int pauseImage = 0;
        int errorImage = 0;
        int secondaryProgressColor = 0;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressImageView, 0, 0);
        try {
            if (attrs != null) {
                width = (int)a.getDimension(R.styleable.ProgressImageView_radius, 75.0f);
                thickness = (int)a.getDimension(R.styleable.ProgressImageView_thickness, 3.0f);
                ringColor = a.getColor(R.styleable.ProgressImageView_ring_color, DEFAULT_RING_COLOR);
                this.completeRingColor = a.getColor(R.styleable.ProgressImageView_complete_ring_color, ringColor);
                secondaryProgressColor = a.getColor(R.styleable.ProgressImageView_secondary_ring_color, 0);
                startImage = a.getResourceId(R.styleable.ProgressImageView_start_image, 0);
                endImage = a.getResourceId(R.styleable.ProgressImageView_end_image, 0);
                errorImage = a.getResourceId(R.styleable.ProgressImageView_error_image, 0);
                progressImage = a.getResourceId(R.styleable.ProgressImageView_progress_image, 0);
                pauseImage = a.getResourceId(R.styleable.ProgressImageView_pause_image, 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        View imageview = View.inflate((Context)context, (int)R.layout.custom_image_view, (ViewGroup)this);
        View progressbar = View.inflate((Context)context, (int)R.layout.progressbar, (ViewGroup)this);
        this.mImageView = (CustomImageView)imageview.findViewById(R.id.imageview);
        int circularImageWidth = (width - thickness) * 2;
        this.mImageView.setDesiredDimensions(circularImageWidth);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(circularImageWidth, circularImageWidth, 17));
        this.mImageView.setStartImage(startImage);
        this.mImageView.setEndImage(endImage);
        this.mImageView.setProgressImage(progressImage);
        this.mImageView.setPauseImage(pauseImage);
        this.mImageView.setErrorImage(errorImage);
        this.mProgressBar = (CustomProgressBar)progressbar.findViewById(R.id.progress);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width * 2 + thickness, width * 2 + thickness, 17));
        try {
            this.mProgressBar.setColor(secondaryProgressColor);
            this.mProgressBar.setInnerRadius(width - thickness);
            this.mProgressBar.setThickness(thickness);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (a != null) {
            a.recycle();
        }
    }

    public void setProgress(int progress) {
        this.mProgressBar.setProgress(progress);
        if (progress == 100) {
            this.mImageView.showEndImage();
            this.mProgressBar.setProgressColor(this.completeRingColor);
        }
    }

    public void updateProgressState(ProgressState progressState) {
        this.progressState = progressState;
        switch (progressState) {
            case START: {
                this.mImageView.showStartImage();
                break;
            }
            case PROGRESS: {
                this.mImageView.showProgressImage();
                break;
            }
            case PAUSED: {
                this.mImageView.showPauseImage();
                break;
            }
            case END: {
                this.mImageView.showEndImage();
                break;
            }
            case ERROR: {
                this.mImageView.showErrorImage();
            }
        }
    }

    public void setState(int progressState) {
        switch (progressState) {
            case 0: {
                this.progressState = ProgressState.START;
                this.mImageView.showStartImage();
                break;
            }
            case 1: {
                this.progressState = ProgressState.PROGRESS;
                this.mImageView.showProgressImage();
                break;
            }
            case 2: {
                this.progressState = ProgressState.PAUSED;
                this.mImageView.showPauseImage();
                break;
            }
            case 3: {
                this.progressState = ProgressState.END;
                this.mImageView.showEndImage();
                break;
            }
            case 4: {
                this.progressState = ProgressState.ERROR;
                this.mImageView.showErrorImage();
            }
        }
    }

    public static int dpToPx(Context context, int dimension) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round((float)dimension * density);
    }

    public static enum ProgressState {
        START(0),
        PROGRESS(1),
        PAUSED(2),
        END(3),
        ERROR(4);

        int value;

        private ProgressState(int i) {
            this.value = i;
        }

        public int value() {
            return this.value;
        }
    }
}

