/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Request;

public abstract class UrlRequest<T extends UrlRequest<?>>
extends BaseRequest<T> {
    private CacheControl mCacheControl;

    public UrlRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    public T cache(CacheControl cacheControl) {
        this.mCacheControl = cacheControl;
        return (T)this;
    }

    @Override
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder request = new Request.Builder();
        if (this.mCacheControl != null) {
            request.cacheControl(this.mCacheControl);
        }
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String string : headers.getNames()) {
                request.addHeader(string, headers.get(string));
            }
        }
        HttpUrl.Builder builder = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                builder.addEncodedQueryParameter(key, String.valueOf(params.get(key)));
            }
        }
        HttpUrl httpUrl = builder.build();
        request.url(httpUrl);
        request.method(this.getRequestMethod(), null);
        EasyLog.print("RequestUrl", String.valueOf(httpUrl));
        EasyLog.print("RequestMethod", this.getRequestMethod());
        if (EasyConfig.getInstance().isLogEnabled()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : params.getNames()) {
                EasyLog.print(key, String.valueOf(params.get(key)));
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        return this.getRequestHandler().requestStart(this.getLifecycleOwner(), this.getRequestApi(), request.build());
    }
}

