/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.JsonBody;
import com.hjq.http.body.ProgressBody;
import com.hjq.http.body.StringBody;
import com.hjq.http.body.UpdateBody;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.listener.OnUpdateListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BodyRequest<T extends BodyRequest<?>>
extends BaseRequest<T> {
    private OnUpdateListener<?> mUpdateListener;
    private RequestBody mRequestBody;

    public BodyRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    public T json(Map<?, ?> map) {
        if (map == null) {
            return (T)this;
        }
        return this.body(new JsonBody(map));
    }

    public T json(List<?> list) {
        if (list == null) {
            return (T)this;
        }
        return this.body(new JsonBody(list));
    }

    public T json(String json) {
        if (json == null) {
            return (T)this;
        }
        return this.body(new JsonBody(json));
    }

    public T text(String text) {
        if (text == null) {
            return (T)this;
        }
        return this.body(new StringBody(text));
    }

    public T body(RequestBody body) {
        this.mRequestBody = body;
        return (T)this;
    }

    @Override
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder request = new Request.Builder();
        request.url(url);
        EasyLog.print("RequestUrl", url);
        EasyLog.print("RequestMethod", this.getRequestMethod());
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        RequestBody body = this.mRequestBody != null ? this.mRequestBody : this.createBody(params, type);
        request.method(this.getRequestMethod(), body);
        if (EasyConfig.getInstance().isLogEnabled()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            if (body instanceof FormBody || body instanceof MultipartBody || body instanceof ProgressBody) {
                for (String key : params.getNames()) {
                    Object value = params.get(key);
                    if (value instanceof String) {
                        EasyLog.print(key, "\"" + value + "\"");
                        continue;
                    }
                    EasyLog.print(key, String.valueOf(value));
                }
            } else if (body instanceof JsonBody) {
                EasyLog.json(body.toString());
            } else {
                EasyLog.print(body.toString());
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        return this.getRequestHandler().requestStart(this.getLifecycleOwner(), this.getRequestApi(), request.build());
    }

    @Override
    public T request(OnHttpListener<?> listener) {
        if (listener instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listener;
        }
        return (T)((BodyRequest)super.request(listener));
    }

    private RequestBody createBody(HttpParams params, BodyType type) {
        if (params.isMultipart() && !params.isEmpty()) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            for (String key : params.getNames()) {
                MultipartBody.Part part;
                Object object = params.get(key);
                if (object instanceof File) {
                    part = EasyUtils.createPart(key, (File)object);
                    if (part == null) continue;
                    builder.addPart(part);
                    continue;
                }
                if (object instanceof InputStream) {
                    part = EasyUtils.createPart(key, (InputStream)object);
                    if (part == null) continue;
                    builder.addPart(part);
                    continue;
                }
                if (object instanceof RequestBody) {
                    if (object instanceof UpdateBody) {
                        builder.addFormDataPart(key, EasyUtils.encodeString(((UpdateBody)((Object)object)).getName()), (RequestBody)object);
                        continue;
                    }
                    builder.addFormDataPart(key, null, (RequestBody)object);
                    continue;
                }
                if (object instanceof List && EasyUtils.isFileList((List)object)) {
                    for (Object item : (List)object) {
                        MultipartBody.Part part2 = EasyUtils.createPart(key, (File)item);
                        if (part2 == null) continue;
                        builder.addPart(part2);
                    }
                    continue;
                }
                builder.addFormDataPart(key, String.valueOf(object));
            }
            if (this.mUpdateListener != null) {
                return new ProgressBody((RequestBody)builder.build(), this.getLifecycleOwner(), this.mUpdateListener);
            }
            return builder.build();
        }
        if (type == BodyType.JSON) {
            if (this.mUpdateListener != null) {
                return new ProgressBody(new JsonBody(params.getParams()), this.getLifecycleOwner(), this.mUpdateListener);
            }
            return new JsonBody(params.getParams());
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                builder.add(key, String.valueOf(params.get(key)));
            }
        }
        if (this.mUpdateListener != null) {
            return new ProgressBody((RequestBody)builder.build(), this.getLifecycleOwner(), this.mUpdateListener);
        }
        return builder.build();
    }
}

