/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.annotation.HttpHeader;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.callback.NormalCallback;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.config.IRequestClient;
import com.hjq.http.config.IRequestHandler;
import com.hjq.http.config.IRequestHost;
import com.hjq.http.config.IRequestInterceptor;
import com.hjq.http.config.IRequestPath;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.IRequestType;
import com.hjq.http.config.RequestApi;
import com.hjq.http.config.RequestServer;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.model.ResponseClass;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseRequest<T extends BaseRequest<?>> {
    private IRequestHandler mRequestHandler = EasyConfig.getInstance().getHandler();
    private IRequestHost mRequestHost = EasyConfig.getInstance().getServer();
    private IRequestPath mRequestPath = EasyConfig.getInstance().getServer();
    private IRequestType mRequestType = EasyConfig.getInstance().getServer();
    private IRequestClient mRequestClient = EasyConfig.getInstance().getServer();
    private IRequestApi mRequestApi;
    private final LifecycleOwner mLifecycleOwner;
    private CallProxy mCallProxy;
    private String mTag;
    private long mDelayMillis;

    public BaseRequest(LifecycleOwner lifecycleOwner) {
        if (lifecycleOwner == null) {
            throw new IllegalArgumentException("are you ok?");
        }
        this.mLifecycleOwner = lifecycleOwner;
        this.tag(lifecycleOwner);
    }

    public T api(Class<? extends IRequestApi> api) {
        try {
            return this.api(api.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T api(String api) {
        return this.api(new RequestApi(api));
    }

    public T api(IRequestApi api) {
        this.mRequestApi = api;
        if (api instanceof IRequestHost) {
            this.mRequestHost = (IRequestHost)((Object)api);
        }
        if (api instanceof IRequestPath) {
            this.mRequestPath = (IRequestPath)((Object)api);
        }
        if (api instanceof IRequestType) {
            this.mRequestType = (IRequestType)((Object)api);
        }
        if (api instanceof IRequestClient) {
            this.mRequestClient = (IRequestClient)((Object)api);
        }
        if (api instanceof IRequestHandler) {
            this.mRequestHandler = (IRequestHandler)((Object)api);
        }
        return (T)this;
    }

    public T server(Class<? extends IRequestServer> api) {
        try {
            return this.server(api.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T server(String host) {
        return this.server(new RequestServer(host));
    }

    public T server(IRequestServer server) {
        this.mRequestHost = server;
        this.mRequestPath = server;
        this.mRequestType = server;
        this.mRequestClient = server;
        return (T)this;
    }

    public T delay(long delay, TimeUnit unit) {
        return this.delay(unit.toMillis(delay));
    }

    public T delay(long delayMillis) {
        this.mDelayMillis = delayMillis;
        return (T)this;
    }

    public T handler(IRequestHandler handler) {
        this.mRequestHandler = handler;
        return (T)this;
    }

    public T tag(Object tag) {
        if (tag != null) {
            return this.tag(String.valueOf(tag));
        }
        return (T)this;
    }

    public T tag(String tag) {
        this.mTag = tag;
        return (T)this;
    }

    protected Call createCall() {
        BodyType type = this.mRequestType.getType();
        HttpParams params = new HttpParams();
        HttpHeaders headers = new HttpHeaders();
        Field[] fields = this.mRequestApi.getClass().getDeclaredFields();
        params.setMultipart(EasyUtils.isMultipart(fields));
        if (params.isMultipart() && type != BodyType.FORM) {
            type = BodyType.FORM;
        }
        block6: for (Field field : fields) {
            field.setAccessible(true);
            try {
                Map map;
                String key;
                Object value = field.get(this.mRequestApi);
                HttpRename annotation = field.getAnnotation(HttpRename.class);
                if (annotation != null) {
                    key = annotation.value();
                } else {
                    key = field.getName();
                    if (key.matches("this\\$\\d+") || "Companion".equals(key)) continue;
                }
                if (field.isAnnotationPresent(HttpIgnore.class)) {
                    if (field.isAnnotationPresent(HttpHeader.class)) {
                        headers.remove(key);
                        continue;
                    }
                    params.remove(key);
                    continue;
                }
                if (EasyUtils.isEmpty(value)) continue;
                if (field.isAnnotationPresent(HttpHeader.class)) {
                    if (value instanceof Map) {
                        map = (Map)value;
                        for (Object o : map.keySet()) {
                            if (o == null || map.get(o) == null) continue;
                            headers.put(String.valueOf(o), String.valueOf(map.get(o)));
                        }
                        continue;
                    }
                    headers.put(key, String.valueOf(value));
                    continue;
                }
                switch (type) {
                    case FORM: {
                        if (value instanceof Map) {
                            map = (Map)value;
                            for (Object o : map.keySet()) {
                                if (o == null || map.get(o) == null) continue;
                                params.put(String.valueOf(o), map.get(o));
                            }
                            continue block6;
                        }
                        params.put(key, value);
                        break;
                    }
                    case JSON: {
                        if (value instanceof List) {
                            params.put(key, EasyUtils.listToJsonArray((List)value));
                            break;
                        }
                        if (value instanceof Map) {
                            params.put(key, EasyUtils.mapToJsonObject((Map)value));
                            break;
                        }
                        if (EasyUtils.isBeanType(value)) {
                            params.put(key, EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                            break;
                        }
                        params.put(key, value);
                        break;
                    }
                }
            }
            catch (IllegalAccessException e) {
                EasyLog.print(e);
            }
        }
        String url = this.mRequestHost.getHost() + this.mRequestPath.getPath() + this.mRequestApi.getApi();
        IRequestInterceptor interceptor = EasyConfig.getInstance().getInterceptor();
        if (interceptor != null) {
            interceptor.interceptArguments(this.mRequestApi, params, headers);
        }
        return this.mRequestClient.getClient().newCall(this.createRequest(url, this.mTag, params, headers, type));
    }

    public T request(OnHttpListener<?> listener) {
        if (this.mDelayMillis > 0L) {
            EasyLog.print("RequestDelay", String.valueOf(this.mDelayMillis));
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        EasyUtils.postDelayed(() -> {
            if (!HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
                EasyLog.print("\u5bbf\u4e3b\u5df2\u88ab\u9500\u6bc1\uff0c\u8bf7\u6c42\u65e0\u6cd5\u8fdb\u884c");
                return;
            }
            EasyLog.print(stackTrace);
            this.mCallProxy = new CallProxy(this.createCall());
            this.mCallProxy.enqueue(new NormalCallback(this.getLifecycleOwner(), this.mCallProxy, this.mRequestApi, this.mRequestHandler, listener));
        }, this.mDelayMillis);
        return (T)this;
    }

    public <Bean> Bean execute(ResponseClass<Bean> responseClass) throws Exception {
        if (this.mDelayMillis > 0L) {
            EasyLog.print("RequestDelay", String.valueOf(this.mDelayMillis));
            Thread.sleep(this.mDelayMillis);
        }
        if (!HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
            EasyLog.print("\u5bbf\u4e3b\u5df2\u88ab\u9500\u6bc1\uff0c\u8bf7\u6c42\u65e0\u6cd5\u8fdb\u884c");
            throw new IllegalStateException("The host has been destroyed and the request cannot proceed");
        }
        EasyLog.print(new Throwable().getStackTrace());
        try {
            this.mCallProxy = new CallProxy(this.createCall());
            Response response = this.mCallProxy.execute();
            return (Bean)this.mRequestHandler.requestSucceed(this.getLifecycleOwner(), this.getRequestApi(), response, EasyUtils.getReflectType(responseClass));
        }
        catch (Exception e) {
            throw this.mRequestHandler.requestFail(this.getLifecycleOwner(), this.getRequestApi(), e);
        }
    }

    public T cancel() {
        if (this.mCallProxy != null) {
            this.mCallProxy.cancel();
        }
        return (T)this;
    }

    protected LifecycleOwner getLifecycleOwner() {
        return this.mLifecycleOwner;
    }

    protected abstract String getRequestMethod();

    protected long getDelayMillis() {
        return this.mDelayMillis;
    }

    protected IRequestApi getRequestApi() {
        return this.mRequestApi;
    }

    protected IRequestHandler getRequestHandler() {
        return this.mRequestHandler;
    }

    protected abstract Request createRequest(String var1, String var2, HttpParams var3, HttpHeaders var4, BodyType var5);
}

