/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.config.IRequestHandler;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import okhttp3.Response;

public final class NormalCallback
extends BaseCallback {
    private final LifecycleOwner mLifecycle;
    private final OnHttpListener mListener;
    private final IRequestApi mRequestApi;
    private final IRequestHandler mRequestHandler;

    public NormalCallback(LifecycleOwner lifecycleOwner, CallProxy call, IRequestApi api, IRequestHandler handler, OnHttpListener listener) {
        super(lifecycleOwner, call);
        this.mLifecycle = lifecycleOwner;
        this.mRequestApi = api;
        this.mListener = listener;
        this.mRequestHandler = handler;
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.getLifecycleOwner())) {
                return;
            }
            this.mListener.onStart(call);
        });
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        EasyLog.print("RequestConsuming\uff1a" + (response.receivedResponseAtMillis() - response.sentRequestAtMillis()) + " ms");
        Object result = this.mRequestHandler.requestSucceed(this.mLifecycle, this.mRequestApi, response, EasyUtils.getReflectType(this.mListener));
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.getLifecycleOwner())) {
                return;
            }
            this.mListener.onSucceed(result);
            this.mListener.onEnd(this.getCall());
        });
    }

    @Override
    protected void onFailure(Exception e) {
        Exception exception = this.mRequestHandler.requestFail(this.mLifecycle, this.mRequestApi, e);
        EasyLog.print(exception);
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.getLifecycleOwner())) {
                return;
            }
            this.mListener.onFail(exception);
            this.mListener.onEnd(this.getCall());
        });
    }
}

