/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnUpdateListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class ProgressBody
extends RequestBody {
    private final RequestBody mRequestBody;
    private final OnUpdateListener<?> mListener;
    private final LifecycleOwner mLifecycleOwner;
    private long mTotalByte;
    private long mUpdateByte;
    private int mUpdateProgress;

    public ProgressBody(RequestBody body, LifecycleOwner lifecycleOwner, OnUpdateListener<?> listener) {
        this.mRequestBody = body;
        this.mLifecycleOwner = lifecycleOwner;
        this.mListener = listener;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.mRequestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.mTotalByte = this.contentLength();
        sink = Okio.buffer((Sink)new ForwardingSink((Sink)sink){

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                ProgressBody.this.mUpdateByte = ProgressBody.this.mUpdateByte + byteCount;
                EasyUtils.post(() -> {
                    int progress;
                    if (ProgressBody.this.mListener != null && HttpLifecycleManager.isLifecycleActive(ProgressBody.this.mLifecycleOwner)) {
                        ProgressBody.this.mListener.onByte(ProgressBody.this.mTotalByte, ProgressBody.this.mUpdateByte);
                    }
                    if ((progress = EasyUtils.getProgressProgress(ProgressBody.this.mTotalByte, ProgressBody.this.mUpdateByte)) != ProgressBody.this.mUpdateProgress) {
                        ProgressBody.this.mUpdateProgress = progress;
                        if (ProgressBody.this.mListener != null && HttpLifecycleManager.isLifecycleActive(ProgressBody.this.mLifecycleOwner)) {
                            ProgressBody.this.mListener.onProgress(progress);
                        }
                        EasyLog.print("\u6b63\u5728\u8fdb\u884c\u4e0a\u4f20\uff0c\u603b\u5b57\u8282\uff1a" + ProgressBody.this.mTotalByte + "\uff0c\u5df2\u4e0a\u4f20\uff1a" + ProgressBody.this.mUpdateByte + "\uff0c\u8fdb\u5ea6\uff1a" + progress + "%");
                    }
                });
            }
        });
        this.mRequestBody.writeTo(sink);
        sink.flush();
    }
}

