/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.annotation.HttpHeader;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.config.IRequestHost;
import com.hjq.http.config.IRequestInterceptor;
import com.hjq.http.config.IRequestPath;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.IRequestType;
import com.hjq.http.config.RequestApi;
import com.hjq.http.config.RequestServer;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class BaseRequest<T extends BaseRequest> {
    private OkHttpClient mClient = EasyConfig.getInstance().getClient();
    private IRequestHost mRequestHost = EasyConfig.getInstance().getServer();
    private IRequestPath mRequestPath = EasyConfig.getInstance().getServer();
    private IRequestType mRequestType = EasyConfig.getInstance().getServer();
    private IRequestApi mRequestApi;
    private LifecycleOwner mLifecycleOwner;
    private String mTag;

    public BaseRequest(LifecycleOwner lifecycle) {
        this.mLifecycleOwner = lifecycle;
    }

    public T api(Class<? extends IRequestApi> api) {
        try {
            return this.api(api.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T api(String api) {
        return this.api(new RequestApi(api));
    }

    public T api(IRequestApi api) {
        this.mRequestApi = api;
        if (api instanceof IRequestHost) {
            this.mRequestHost = (IRequestHost)((Object)api);
        }
        if (api instanceof IRequestPath) {
            this.mRequestPath = (IRequestPath)((Object)api);
        }
        if (api instanceof IRequestType) {
            this.mRequestType = (IRequestType)((Object)api);
        }
        return (T)this;
    }

    public T server(Class<? extends IRequestServer> api) {
        try {
            return this.server(api.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T server(String host) {
        return this.server(new RequestServer(host));
    }

    public T server(IRequestServer server) {
        this.mRequestHost = server;
        this.mRequestPath = server;
        this.mRequestType = server;
        return (T)this;
    }

    public T tag(Object tag) {
        if (tag != null) {
            return this.tag(tag.toString());
        }
        return (T)this;
    }

    public T tag(String tag) {
        this.mTag = tag;
        return (T)this;
    }

    public T client(OkHttpClient client) {
        this.mClient = client;
        return (T)this;
    }

    public Call create() {
        BodyType type = this.mRequestType.getType();
        HttpParams params = new HttpParams();
        HttpHeaders headers = new HttpHeaders();
        Field[] fields = this.mRequestApi.getClass().getDeclaredFields();
        params.setMultipart(EasyUtils.isMultipart(fields));
        if (type != BodyType.FORM && params.isMultipart()) {
            type = BodyType.FORM;
        }
        block6: for (Field field : fields) {
            field.setAccessible(true);
            if (this.mRequestApi.getClass().toString().startsWith(field.getType().toString())) continue;
            try {
                Map map;
                Object value = field.get(this.mRequestApi);
                String key = field.isAnnotationPresent(HttpRename.class) ? field.getAnnotation(HttpRename.class).value() : field.getName();
                if (field.isAnnotationPresent(HttpIgnore.class)) {
                    if (field.isAnnotationPresent(HttpHeader.class)) {
                        headers.remove(key);
                        continue;
                    }
                    params.remove(key);
                    continue;
                }
                if (EasyUtils.isEmpty(value)) continue;
                if (field.isAnnotationPresent(HttpHeader.class)) {
                    if (value instanceof Map) {
                        map = (Map)value;
                        for (Object o : map.keySet()) {
                            if (o == null || map.get(o) == null) continue;
                            headers.put(o.toString(), map.get(o).toString());
                        }
                        continue;
                    }
                    headers.put(key, value.toString());
                    continue;
                }
                switch (type) {
                    case FORM: {
                        if (value instanceof Map) {
                            map = (Map)value;
                            for (Object o : map.keySet()) {
                                if (o == null || map.get(o) == null) continue;
                                params.put(o.toString(), map.get(o));
                            }
                            continue block6;
                        }
                        params.put(key, value);
                        break;
                    }
                    case JSON: {
                        if (value instanceof List) {
                            params.put(key, EasyUtils.listToJsonArray((List)value));
                            break;
                        }
                        if (value instanceof Map) {
                            params.put(key, EasyUtils.mapToJsonObject((Map)value));
                            break;
                        }
                        if (EasyUtils.isBeanType(value)) {
                            params.put(key, EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                            break;
                        }
                        params.put(key, value);
                        break;
                    }
                }
            }
            catch (IllegalAccessException e) {
                EasyLog.print(e);
            }
        }
        String url = this.mRequestHost.getHost() + this.mRequestPath.getPath() + this.mRequestApi.getApi();
        IRequestInterceptor interceptor = EasyConfig.getInstance().getInterceptor();
        if (interceptor != null) {
            interceptor.intercept(url, this.mTag, params, headers);
        }
        return this.mClient.newCall(this.create(url, this.mTag, params, headers, type));
    }

    public LifecycleOwner getLifecycleOwner() {
        return this.mLifecycleOwner;
    }

    protected abstract Request create(String var1, String var2, HttpParams var3, HttpHeaders var4, BodyType var5);
}

