/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.config;

import android.text.TextUtils;
import android.util.Log;
import com.hjq.http.EasyConfig;
import com.hjq.http.config.ILogStrategy;

public final class LogStrategy
implements ILogStrategy {
    @Override
    public void print(String log) {
        Log.d((String)EasyConfig.getInstance().getLogTag(), (String)(log != null ? log : "null"));
    }

    @Override
    public void json(String json) {
        String text = ILogStrategy.stringToJSON(json);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            text = " \n" + text;
            int segmentSize = 3072;
            long length = text.length();
            if (length <= (long)segmentSize) {
                this.print(text);
            } else {
                while (text.length() > segmentSize) {
                    String logContent = text.substring(0, segmentSize);
                    text = text.replace(logContent, "");
                    this.print(logContent);
                }
                this.print(text);
            }
        }
    }

    @Override
    public void print(Throwable throwable) {
        Log.e((String)EasyConfig.getInstance().getLogTag(), (String)throwable.getMessage(), (Throwable)throwable);
    }

    @Override
    public void print(String key, String value) {
        this.print(key + " = " + value);
    }
}

