/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import com.hjq.http.EasyLog;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static boolean runOnUiThread(boolean execute, Runnable r) {
        if (execute) {
            return EasyUtils.runOnUiThread(r);
        }
        return false;
    }

    public static boolean runOnUiThread(Runnable r) {
        return HANDLER.post(r);
    }

    public static boolean postDelayed(Runnable r, long delayMillis) {
        return HANDLER.postDelayed(r, delayMillis);
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            EasyLog.print(e);
        }
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5(File file) {
        if (file == null) {
            return null;
        }
        DigestInputStream inputStream = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            inputStream = new DigestInputStream(fis, messageDigest);
            byte[] buffer = new byte[262144];
            while (inputStream.read(buffer) > 0) {
            }
            messageDigest = inputStream.getMessageDigest();
            byte[] md5 = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            String string = sb.toString().toLowerCase();
            EasyUtils.closeStream(inputStream);
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            EasyLog.print(e);
        }
        finally {
            EasyUtils.closeStream(inputStream);
        }
        return null;
    }

    public static boolean isBeanType(Object object) {
        return !(object instanceof Number) && !(object instanceof CharSequence) && !(object instanceof Boolean) && !(object instanceof File) && !(object instanceof InputStream) && !(object instanceof RequestBody) && !(object instanceof Character) && !(object instanceof JSONObject) && !(object instanceof JSONArray);
    }

    public static boolean isMultipart(Field[] fields) {
        for (Field field : fields) {
            Type[] actualTypeArguments;
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            if (File.class.equals(clazz)) {
                return true;
            }
            if (InputStream.class.equals(clazz)) {
                return true;
            }
            if (RequestBody.class.equals(clazz)) {
                return true;
            }
            if (!List.class.equals(clazz) || (actualTypeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()) == null || actualTypeArguments.length != 1 || !File.class.equals((Object)actualTypeArguments[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileList(List list) {
        if (list != null && !list.isEmpty()) {
            for (Object object : list) {
                if (object instanceof File) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof List && ((List)object).isEmpty()) {
            return true;
        }
        return object instanceof Map && ((Map)object).isEmpty();
    }

    public static JSONArray listToJsonArray(List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list != null && !list.isEmpty()) {
            for (Object item : list) {
                if (item instanceof List) {
                    jsonArray.put((Object)EasyUtils.listToJsonArray((List)item));
                    continue;
                }
                if (item instanceof Map) {
                    jsonArray.put((Object)EasyUtils.mapToJsonObject((Map)item));
                    continue;
                }
                if (EasyUtils.isBeanType(item)) {
                    jsonArray.put((Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(item)));
                    continue;
                }
                jsonArray.put(item);
            }
        }
        return jsonArray;
    }

    public static JSONObject mapToJsonObject(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject();
        if (map != null && !map.isEmpty()) {
            Set<?> keySet = map.keySet();
            for (Object key : keySet) {
                Object value = map.get(key);
                try {
                    if (value instanceof List) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.listToJsonArray((List)value));
                        continue;
                    }
                    if (value instanceof Map) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject((Map)value));
                        continue;
                    }
                    if (EasyUtils.isBeanType(value)) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                        continue;
                    }
                    jsonObject.put(String.valueOf(key), value);
                }
                catch (JSONException e) {
                    EasyLog.print(e);
                }
            }
        }
        return jsonObject;
    }

    public static HashMap<String, Object> beanToHashMap(Object object) {
        Field[] fields;
        HashMap<String, JSONArray> data = null;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (object.getClass().toString().startsWith(field.getType().toString())) continue;
            try {
                Object value = field.get(object);
                if (EasyUtils.isEmpty(value)) continue;
                String key = field.isAnnotationPresent(HttpRename.class) ? field.getAnnotation(HttpRename.class).value() : field.getName();
                if (field.isAnnotationPresent(HttpIgnore.class)) continue;
                if (data == null) {
                    data = new HashMap<String, JSONArray>(fields.length);
                }
                if (value instanceof List) {
                    data.put(key, EasyUtils.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Map) {
                    data.put(key, (JSONArray)EasyUtils.mapToJsonObject((Map)value));
                    continue;
                }
                if (EasyUtils.isBeanType(value)) {
                    data.put(key, (JSONArray)EasyUtils.beanToHashMap(value));
                    continue;
                }
                data.put(key, (JSONArray)value);
            }
            catch (IllegalAccessException e) {
                EasyLog.print(e);
            }
        }
        return data;
    }
}

